/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.time.LocalDate;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class BulgarianIdNumber
implements IdNumberGenerator {
    private static final int[] CHECKSUM_WEIGHTS = new int[]{2, 4, 8, 5, 10, 9, 7, 3, 6};
    private static final int[] EVEN_DIGITS = new int[]{0, 2, 4, 6, 8};
    private static final int[] ODD_DIGITS = new int[]{1, 3, 5, 7, 9};

    @Override
    public String countryCode() {
        return "BG";
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        LocalDate birthday = Utils.birthday(faker, request);
        PersonIdNumber.Gender gender = Utils.gender(faker, request);
        String basePart = this.basePart(faker, birthday, gender);
        String idNumber = basePart + this.checksum(basePart);
        return new PersonIdNumber(idNumber, birthday, gender);
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        String basePart = this.basePart(faker, faker.timeAndDate().birthday(), Utils.randomGender(faker));
        return basePart + (this.checksum(basePart) + 1) % 10;
    }

    private String basePart(BaseProviders faker, LocalDate birthDate, PersonIdNumber.Gender gender) {
        return this.yy(birthDate) + this.mm(birthDate) + this.dd(birthDate) + this.order(faker, gender);
    }

    private String yy(LocalDate birthDate) {
        return "%02d".formatted(birthDate.getYear() % 100);
    }

    private String mm(LocalDate birthDate) {
        int monthAddition = birthDate.getYear() < 1900 ? 20 : (birthDate.getYear() >= 2000 ? 40 : 0);
        return "%02d".formatted(birthDate.getMonthValue() + monthAddition);
    }

    private String dd(LocalDate birthDate) {
        return "%02d".formatted(birthDate.getDayOfMonth());
    }

    private String order(BaseProviders faker, PersonIdNumber.Gender gender) {
        int[] availableLastDigits = switch (gender) {
            default -> throw new IncompatibleClassChangeError();
            case PersonIdNumber.Gender.FEMALE -> ODD_DIGITS;
            case PersonIdNumber.Gender.MALE -> EVEN_DIGITS;
        };
        int lastDigit = availableLastDigits[faker.number().numberBetween(0, 5)];
        return faker.number().digits(2) + lastDigit;
    }

    int checksum(String text) {
        int checksum = Utils.multiply(text, CHECKSUM_WEIGHTS);
        return checksum % 11 % 10;
    }
}

