/*
 * Decompiled with CFR 0.152.
 */
package net.datafaker.idnumbers;

import java.util.List;
import java.util.regex.Pattern;
import net.datafaker.idnumbers.IdNumberGenerator;
import net.datafaker.idnumbers.Utils;
import net.datafaker.providers.base.BaseProviders;
import net.datafaker.providers.base.IdNumber;
import net.datafaker.providers.base.PersonIdNumber;

public class AmericanIdNumber
implements IdNumberGenerator {
    private static final List<String> INVALID_SSNS = List.of("0{3}-\\d{2}-\\d{4}", "\\d{3}-0{2}-\\d{4}", "\\d{3}-\\d{2}-0{4}", "666-\\d{2}-\\d{4}", "9\\d{2}-\\d{2}-\\d{4}");
    private static final List<Pattern> INVALID_SSN_PATTERNS = INVALID_SSNS.stream().map(Pattern::compile).toList();

    @Override
    public String countryCode() {
        return "US";
    }

    @Deprecated
    public String getValidSsn(BaseProviders f) {
        return this.generateValid(f);
    }

    @Override
    public String generateValid(BaseProviders f) {
        String ssn = f.regexify("[0-8]\\d{2}-\\d{2}-\\d{4}");
        boolean isValid = INVALID_SSN_PATTERNS.stream().noneMatch(invalidSSNPattern -> invalidSSNPattern.matcher(ssn).matches());
        return isValid ? ssn : this.generateValid(f);
    }

    @Override
    public PersonIdNumber generateValid(BaseProviders faker, IdNumber.IdNumberRequest request) {
        return new PersonIdNumber(this.generateValid(faker), Utils.birthday(faker, request), Utils.gender(faker, request));
    }

    @Override
    public String generateInvalid(BaseProviders faker) {
        return faker.regexify(faker.options().nextElement(INVALID_SSNS));
    }
}

