/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.editor.client.IsEditor;
import com.google.gwt.editor.client.LeafValueEditor;
import com.google.gwt.editor.client.adapters.TakesValueEditor;
import com.google.gwt.text.shared.Parser;
import com.google.gwt.text.shared.Renderer;
import com.google.gwt.text.shared.ToStringRenderer;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.LabelBase;
import com.google.gwt.user.client.ui.RootPanel;
import java.text.ParseException;

public class ValueLabel<T>
extends LabelBase<T>
implements TakesValue<T>,
IsEditor<LeafValueEditor<T>> {
    private final Renderer<? super T> renderer;
    private T value;
    private LeafValueEditor<T> editor;

    public static <T> ValueLabel<T> wrap(Element element, Renderer<? super T> renderer) {
        assert (Document.get().getBody().isOrHasChild(element));
        ValueLabel<T> label = new ValueLabel<T>(element, renderer);
        label.onAttach();
        RootPanel.detachOnWindowClose(label);
        return label;
    }

    public static <T> ValueLabel<T> wrap(Element element, Renderer<? super T> renderer, Parser<? extends T> parser) throws ParseException {
        ValueLabel<T> label = ValueLabel.wrap(element, renderer);
        label.setValue(parser.parse(element.getInnerText()));
        label.onAttach();
        RootPanel.detachOnWindowClose(label);
        return label;
    }

    public ValueLabel() {
        this(ToStringRenderer.instance());
    }

    @UiConstructor
    public ValueLabel(Renderer<? super T> renderer) {
        super(true);
        this.renderer = renderer;
    }

    protected ValueLabel(Element element, Renderer<? super T> renderer) {
        super(element);
        this.renderer = renderer;
    }

    @Override
    public LeafValueEditor<T> asEditor() {
        if (this.editor == null) {
            this.editor = TakesValueEditor.of(this);
        }
        return this.editor;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        this.value = value;
        this.directionalTextHelper.setText(this.renderer.render(value));
        this.updateHorizontalAlignment();
    }
}

