/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.uibinder.elementparsers;

import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.uibinder.elementparsers.AttributeMessageInterpreter;
import com.google.gwt.uibinder.elementparsers.ComputedAttributeInterpreter;
import com.google.gwt.uibinder.elementparsers.FieldInterpreter;
import com.google.gwt.uibinder.elementparsers.HtmlMessageInterpreter;
import com.google.gwt.uibinder.elementparsers.InterpreterPipe;
import com.google.gwt.uibinder.elementparsers.UiSafeHtmlInterpreter;
import com.google.gwt.uibinder.elementparsers.UiTextInterpreter;
import com.google.gwt.uibinder.rebind.FieldWriter;
import com.google.gwt.uibinder.rebind.UiBinderWriter;
import com.google.gwt.uibinder.rebind.XMLAttribute;
import com.google.gwt.uibinder.rebind.XMLElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HtmlInterpreter
implements XMLElement.Interpreter<String> {
    private static final Set<String> URI_ATTRIBUTES;
    private final UiBinderWriter writer;
    private final InterpreterPipe<String> pipe;

    public static HtmlInterpreter newInterpreterForUiObject(UiBinderWriter writer, String uiExpression) {
        String ancestorExpression = writer.useLazyWidgetBuilders() ? uiExpression : uiExpression + ".getElement()";
        return new HtmlInterpreter(writer, ancestorExpression, new HtmlMessageInterpreter(writer, ancestorExpression));
    }

    public HtmlInterpreter(UiBinderWriter writer, String ancestorExpression, XMLElement.Interpreter<String> messageInterpreter) {
        this.writer = writer;
        this.pipe = new InterpreterPipe();
        this.pipe.add(new FieldInterpreter(writer, ancestorExpression));
        this.pipe.add(new UiTextInterpreter(writer));
        this.pipe.add(new UiSafeHtmlInterpreter(writer));
        this.pipe.add(new ComputedAttributeInterpreter(writer, new AttributeTypist()));
        this.pipe.add(new AttributeMessageInterpreter(writer));
        this.pipe.add(messageInterpreter);
    }

    public String interpretElement(XMLElement elem) throws UnableToCompleteException {
        if (this.writer.useLazyWidgetBuilders() && this.writer.isElementAssignableTo(elem, SafeHtml.class)) {
            FieldWriter childField = this.writer.parseElementToField(elem);
            return this.writer.tokenForSafeHtmlExpression(elem, childField.getNextReference());
        }
        if (this.writer.isImportedElement(elem)) {
            this.writer.die(elem, "Not allowed in an HTML context", new Object[0]);
        }
        if (elem.getNamespaceUri() != null && !this.writer.isBinderElement(elem)) {
            this.writer.die(elem, "Prefix \"%s:\" has unrecognized xmlns \"%s\" (bad import?)", new Object[]{elem.getPrefix(), elem.getNamespaceUri()});
        }
        return this.pipe.interpretElement(elem);
    }

    static {
        String[] urlAttributes = new String[]{"action", "background", "classid", "cite", "codebase", "data", "formaction", "href", "icon", "longdesc", "manifest", "profile", "poster", "src", "usemap"};
        URI_ATTRIBUTES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(urlAttributes)));
    }

    private class AttributeTypist
    implements ComputedAttributeInterpreter.Delegate {
        private AttributeTypist() {
        }

        @Override
        public String getAttributeToken(XMLAttribute attribute) throws UnableToCompleteException {
            if (URI_ATTRIBUTES.contains(attribute.getLocalName())) {
                return HtmlInterpreter.this.writer.tokenForSafeUriExpression(attribute.getElement(), attribute.consumeSafeUriOrStringAttribute());
            }
            return HtmlInterpreter.this.writer.tokenForStringExpression(attribute.getElement(), attribute.consumeStringValue());
        }
    }
}

