/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.util;

import com.netflix.hollow.core.memory.ByteArrayOrdinalMap;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.HashSet;

public class ObjectInternPool {
    private final ByteArrayOrdinalMap ordinalMap = new ByteArrayOrdinalMap(1024);
    private boolean isReadyToRead = false;
    HashSet<Integer> ordinalsInCycle = new HashSet();

    public void prepareForRead() {
        if (!this.isReadyToRead) {
            this.ordinalMap.prepareForWrite();
        }
        this.ordinalsInCycle.clear();
        this.isReadyToRead = true;
    }

    public boolean ordinalInCurrentCycle(int ordinal) {
        return this.ordinalsInCycle.contains(ordinal);
    }

    public Object getObject(int ordinal, HollowObjectSchema.FieldType type) {
        long pointer = this.ordinalMap.getPointerForData(ordinal);
        switch (type) {
            case BOOLEAN: {
                return this.getBoolean(pointer);
            }
            case FLOAT: {
                return Float.valueOf(this.getFloat(pointer));
            }
            case DOUBLE: {
                return this.getDouble(pointer);
            }
            case INT: {
                return this.getInt(pointer);
            }
            case LONG: {
                return this.getLong(pointer);
            }
            case STRING: {
                return this.getString(pointer);
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)type));
    }

    public boolean getBoolean(long pointer) {
        SegmentedByteArray byteData = this.ordinalMap.getByteData().getUnderlyingArray();
        return byteData.get(pointer) == 1;
    }

    public float getFloat(long pointer) {
        SegmentedByteArray byteData = this.ordinalMap.getByteData().getUnderlyingArray();
        int intBytes = VarInt.readVInt(byteData, pointer);
        return Float.intBitsToFloat(intBytes);
    }

    public double getDouble(long pointer) {
        SegmentedByteArray byteData = this.ordinalMap.getByteData().getUnderlyingArray();
        long longBytes = VarInt.readVLong(byteData, pointer);
        return Double.longBitsToDouble(longBytes);
    }

    public int getInt(long pointer) {
        SegmentedByteArray byteData = this.ordinalMap.getByteData().getUnderlyingArray();
        return VarInt.readVInt(byteData, pointer);
    }

    public long getLong(long pointer) {
        SegmentedByteArray byteData = this.ordinalMap.getByteData().getUnderlyingArray();
        return VarInt.readVLong(byteData, pointer);
    }

    public String getString(long pointer) {
        SegmentedByteArray byteData = this.ordinalMap.getByteData().getUnderlyingArray();
        int length = VarInt.readVInt(byteData, pointer);
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = byteData.get(pointer + 1L + (long)i);
        }
        return new String(bytes);
    }

    public int writeAndGetOrdinal(Object objectToIntern) {
        ByteDataArray buf = new ByteDataArray();
        if (objectToIntern == null) {
            throw new IllegalArgumentException("Cannot intern null objects");
        }
        this.isReadyToRead = false;
        if (objectToIntern instanceof Float) {
            int intBits = Float.floatToIntBits(((Float)objectToIntern).floatValue());
            VarInt.writeVInt(buf, intBits);
        } else if (objectToIntern instanceof Double) {
            long longBits = Double.doubleToLongBits((Double)objectToIntern);
            VarInt.writeVLong(buf, longBits);
        } else if (objectToIntern instanceof Integer) {
            int intBits = (Integer)objectToIntern;
            VarInt.writeVInt(buf, intBits);
        } else if (objectToIntern instanceof Long) {
            long longBits = (Long)objectToIntern;
            VarInt.writeVLong(buf, longBits);
        } else if (objectToIntern instanceof String) {
            VarInt.writeVInt(buf, ((String)objectToIntern).length());
            for (byte b : ((String)objectToIntern).getBytes()) {
                buf.write(b);
            }
        } else if (objectToIntern instanceof Boolean) {
            int valToWrite = (Boolean)objectToIntern != false ? 1 : 0;
            VarInt.writeVInt(buf, valToWrite);
        } else {
            String className = objectToIntern.getClass().getName();
            throw new IllegalArgumentException("Cannot intern object of type " + className);
        }
        int ordinal = this.ordinalMap.getOrAssignOrdinal(buf);
        this.ordinalsInCycle.add(ordinal);
        return ordinal;
    }
}

