/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.traverse;

import com.netflix.hollow.core.read.engine.HollowCollectionTypeReadState;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSchemaSorter;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransitiveSetTraverser {
    private static final Logger log = Logger.getLogger(TransitiveSetTraverser.class.getName());

    public static void addTransitiveMatches(HollowReadStateEngine stateEngine, Map<String, BitSet> matches) {
        List<HollowSchema> schemaList = HollowSchemaSorter.dependencyOrderedSchemaList(stateEngine);
        Collections.reverse(schemaList);
        for (HollowSchema schema : schemaList) {
            BitSet currentMatches = matches.get(schema.getName());
            if (currentMatches == null) continue;
            TransitiveSetTraverser.addTransitiveMatches(stateEngine, schema.getName(), matches);
        }
    }

    public static void removeReferencedOutsideClosure(HollowReadStateEngine stateEngine, Map<String, BitSet> matches) {
        List<HollowSchema> orderedSchemas = HollowSchemaSorter.dependencyOrderedSchemaList(stateEngine);
        Collections.reverse(orderedSchemas);
        for (HollowSchema referencedSchema : orderedSchemas) {
            if (!matches.containsKey(referencedSchema.getName())) continue;
            for (HollowSchema referencerSchema : orderedSchemas) {
                if (referencerSchema == referencedSchema) break;
                if (!matches.containsKey(referencedSchema.getName()) || matches.get(referencedSchema.getName()).cardinality() <= 0) continue;
                TransitiveSetTraverser.traverseReferencesOutsideClosure(stateEngine, referencerSchema.getName(), referencedSchema.getName(), matches, TransitiveSetTraverserAction.REMOVE_REFERENCED_OUTSIDE_CLOSURE);
            }
        }
    }

    public static void addReferencingOutsideClosure(HollowReadStateEngine stateEngine, Map<String, BitSet> matches) {
        List<HollowSchema> orderedSchemas = HollowSchemaSorter.dependencyOrderedSchemaList(stateEngine);
        for (HollowSchema referencerSchema : orderedSchemas) {
            for (HollowSchema referencedSchema : orderedSchemas) {
                if (referencedSchema == referencerSchema) break;
                if (!matches.containsKey(referencedSchema.getName()) || matches.get(referencedSchema.getName()).cardinality() <= 0) continue;
                TransitiveSetTraverser.traverseReferencesOutsideClosure(stateEngine, referencerSchema.getName(), referencedSchema.getName(), matches, TransitiveSetTraverserAction.ADD_REFERENCING_OUTSIDE_CLOSURE);
            }
        }
    }

    private static void addTransitiveMatches(HollowReadStateEngine stateEngine, String type, Map<String, BitSet> matches) {
        HollowTypeReadState typeState = stateEngine.getTypeState(type);
        switch (typeState.getSchema().getSchemaType()) {
            case OBJECT: {
                TransitiveSetTraverser.addTransitiveMatches(stateEngine, (HollowObjectTypeReadState)typeState, matches);
                break;
            }
            case LIST: 
            case SET: {
                TransitiveSetTraverser.addTransitiveMatches(stateEngine, (HollowCollectionTypeReadState)typeState, matches);
                break;
            }
            case MAP: {
                TransitiveSetTraverser.addTransitiveMatches(stateEngine, (HollowMapTypeReadState)typeState, matches);
            }
        }
    }

    private static void addTransitiveMatches(HollowReadStateEngine stateEngine, HollowObjectTypeReadState typeState, Map<String, BitSet> matches) {
        HollowObjectSchema schema = typeState.getSchema();
        BitSet matchingOrdinals = TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getName(), typeState.maxOrdinal());
        BitSet[] childOrdinals = new BitSet[schema.numFields()];
        for (int i = 0; i < schema.numFields(); ++i) {
            HollowTypeReadState childTypeState;
            if (schema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE || (childTypeState = stateEngine.getTypeState(schema.getReferencedType(i))) == null || childTypeState.maxOrdinal() < 0) continue;
            childOrdinals[i] = TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getReferencedType(i), childTypeState.maxOrdinal());
        }
        int ordinal = matchingOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            for (int i = 0; i < childOrdinals.length; ++i) {
                int childOrdinal;
                if (childOrdinals[i] == null || (childOrdinal = typeState.readOrdinal(ordinal, i)) == -1) continue;
                childOrdinals[i].set(childOrdinal);
            }
            ordinal = matchingOrdinals.nextSetBit(ordinal + 1);
        }
    }

    private static void addTransitiveMatches(HollowReadStateEngine stateEngine, HollowCollectionTypeReadState typeState, Map<String, BitSet> matches) {
        HollowCollectionSchema schema = typeState.getSchema();
        BitSet matchingOrdinals = TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getName(), typeState.maxOrdinal());
        HollowTypeReadState childTypeState = stateEngine.getTypeState(schema.getElementType());
        if (childTypeState != null && childTypeState.maxOrdinal() >= 0) {
            BitSet childOrdinals = TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getElementType(), childTypeState.maxOrdinal());
            int ordinal = matchingOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                try {
                    HollowOrdinalIterator iter = typeState.ordinalIterator(ordinal);
                    int elementOrdinal = iter.next();
                    while (elementOrdinal != Integer.MAX_VALUE) {
                        childOrdinals.set(elementOrdinal);
                        elementOrdinal = iter.next();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Add transitive matches failed", e);
                }
                ordinal = matchingOrdinals.nextSetBit(ordinal + 1);
            }
            if (!childOrdinals.isEmpty()) {
                matches.put(schema.getElementType(), childOrdinals);
            }
        }
    }

    private static void addTransitiveMatches(HollowReadStateEngine stateEngine, HollowMapTypeReadState typeState, Map<String, BitSet> matches) {
        HollowMapSchema schema = typeState.getSchema();
        BitSet matchingOrdinals = TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getName(), typeState.maxOrdinal());
        HollowTypeReadState keyTypeState = stateEngine.getTypeState(schema.getKeyType());
        HollowTypeReadState valueTypeState = stateEngine.getTypeState(schema.getValueType());
        BitSet keyOrdinals = keyTypeState == null || keyTypeState.maxOrdinal() < 0 ? null : TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getKeyType(), keyTypeState.maxOrdinal());
        BitSet valueOrdinals = valueTypeState == null || valueTypeState.maxOrdinal() < 0 ? null : TransitiveSetTraverser.getOrCreateBitSet(matches, schema.getValueType(), valueTypeState.maxOrdinal());
        int ordinal = matchingOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            HollowMapEntryOrdinalIterator iter = typeState.ordinalIterator(ordinal);
            while (iter.next()) {
                if (keyOrdinals != null) {
                    keyOrdinals.set(iter.getKey());
                }
                if (valueOrdinals == null) continue;
                valueOrdinals.set(iter.getValue());
            }
            ordinal = matchingOrdinals.nextSetBit(ordinal + 1);
        }
    }

    private static void traverseReferencesOutsideClosure(HollowReadStateEngine stateEngine, String referencerType, String referencedType, Map<String, BitSet> matches, TransitiveSetTraverserAction action) {
        HollowTypeReadState referencerTypeState = stateEngine.getTypeState(referencerType);
        switch (referencerTypeState.getSchema().getSchemaType()) {
            case OBJECT: {
                TransitiveSetTraverser.traverseReferencesOutsideClosure(stateEngine, (HollowObjectTypeReadState)referencerTypeState, referencedType, matches, action);
                break;
            }
            case LIST: 
            case SET: {
                TransitiveSetTraverser.traverseReferencesOutsideClosure(stateEngine, (HollowCollectionTypeReadState)referencerTypeState, referencedType, matches, action);
                break;
            }
            case MAP: {
                TransitiveSetTraverser.traverseReferencesOutsideClosure(stateEngine, (HollowMapTypeReadState)referencerTypeState, referencedType, matches, action);
            }
        }
    }

    private static void traverseReferencesOutsideClosure(HollowReadStateEngine stateEngine, HollowObjectTypeReadState referencerTypeState, String referencedType, Map<String, BitSet> closureMatches, TransitiveSetTraverserAction action) {
        HollowObjectSchema schema = referencerTypeState.getSchema();
        BitSet referencedClosureMatches = TransitiveSetTraverser.getOrCreateBitSet(closureMatches, referencedType, stateEngine.getTypeState(referencedType).maxOrdinal());
        BitSet referencerClosureMatches = TransitiveSetTraverser.getOrCreateBitSet(closureMatches, schema.getName(), referencerTypeState.maxOrdinal());
        for (int i = 0; i < schema.numFields(); ++i) {
            if (schema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE || !referencedType.equals(schema.getReferencedType(i))) continue;
            BitSet allReferencerOrdinals = TransitiveSetTraverser.getPopulatedOrdinals(referencerTypeState);
            int ordinal = allReferencerOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                int refOrdinal;
                if (!referencerClosureMatches.get(ordinal) && (refOrdinal = referencerTypeState.readOrdinal(ordinal, i)) != -1 && referencedClosureMatches.get(refOrdinal)) {
                    action.foundReference(referencerClosureMatches, ordinal, referencedClosureMatches, refOrdinal);
                }
                ordinal = allReferencerOrdinals.nextSetBit(ordinal + 1);
            }
        }
    }

    private static void traverseReferencesOutsideClosure(HollowReadStateEngine stateEngine, HollowCollectionTypeReadState referencerTypeState, String referencedType, Map<String, BitSet> closureMatches, TransitiveSetTraverserAction action) {
        HollowCollectionSchema schema = referencerTypeState.getSchema();
        if (!referencedType.equals(schema.getElementType())) {
            return;
        }
        BitSet referencedClosureMatches = TransitiveSetTraverser.getOrCreateBitSet(closureMatches, referencedType, stateEngine.getTypeState(referencedType).maxOrdinal());
        BitSet referencerClosureMatches = TransitiveSetTraverser.getOrCreateBitSet(closureMatches, schema.getName(), referencerTypeState.maxOrdinal());
        BitSet allReferencerOrdinals = TransitiveSetTraverser.getPopulatedOrdinals(referencerTypeState);
        int ordinal = allReferencerOrdinals.nextSetBit(0);
        while (ordinal != -1) {
            if (!referencerClosureMatches.get(ordinal)) {
                HollowOrdinalIterator iter = referencerTypeState.ordinalIterator(ordinal);
                int refOrdinal = iter.next();
                while (refOrdinal != Integer.MAX_VALUE) {
                    if (referencedClosureMatches.get(refOrdinal)) {
                        action.foundReference(referencerClosureMatches, ordinal, referencedClosureMatches, refOrdinal);
                    }
                    refOrdinal = iter.next();
                }
            }
            ordinal = allReferencerOrdinals.nextSetBit(ordinal + 1);
        }
    }

    private static void traverseReferencesOutsideClosure(HollowReadStateEngine stateEngine, HollowMapTypeReadState referencerTypeState, String referencedType, Map<String, BitSet> closureMatches, TransitiveSetTraverserAction action) {
        HollowMapSchema schema = referencerTypeState.getSchema();
        BitSet referencedClosureMatches = TransitiveSetTraverser.getOrCreateBitSet(closureMatches, referencedType, stateEngine.getTypeState(referencedType).maxOrdinal());
        BitSet referencerClosureMatches = TransitiveSetTraverser.getOrCreateBitSet(closureMatches, schema.getName(), referencerTypeState.maxOrdinal());
        BitSet allReferencerOrdinals = TransitiveSetTraverser.getPopulatedOrdinals(referencerTypeState);
        boolean keyTypeMatches = referencedType.equals(schema.getKeyType());
        boolean valueTypeMatches = referencedType.equals(schema.getValueType());
        if (keyTypeMatches || valueTypeMatches) {
            int ordinal = allReferencerOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                if (!referencerClosureMatches.get(ordinal)) {
                    HollowMapEntryOrdinalIterator iter = referencerTypeState.ordinalIterator(ordinal);
                    while (iter.next()) {
                        int refOrdinal;
                        if (keyTypeMatches && referencedClosureMatches.get(refOrdinal = iter.getKey())) {
                            action.foundReference(referencerClosureMatches, ordinal, referencedClosureMatches, refOrdinal);
                        }
                        if (!valueTypeMatches || !referencedClosureMatches.get(refOrdinal = iter.getValue())) continue;
                        action.foundReference(referencerClosureMatches, ordinal, referencedClosureMatches, refOrdinal);
                    }
                }
                ordinal = allReferencerOrdinals.nextSetBit(ordinal + 1);
            }
        }
    }

    private static BitSet getPopulatedOrdinals(HollowTypeReadState typeState) {
        return typeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
    }

    private static BitSet getOrCreateBitSet(Map<String, BitSet> bitSets, String typeName, int numBitsRequired) {
        BitSet bs;
        if (numBitsRequired < 0) {
            numBitsRequired = 0;
        }
        if ((bs = bitSets.get(typeName)) == null) {
            bs = new BitSet(numBitsRequired);
            bitSets.put(typeName, bs);
        }
        return bs;
    }

    public static interface TransitiveSetTraverserAction {
        public static final TransitiveSetTraverserAction REMOVE_REFERENCED_OUTSIDE_CLOSURE = new TransitiveSetTraverserAction(){

            @Override
            public void foundReference(BitSet referencerClosureMatches, int referencerOrdinal, BitSet referencedClosureMatches, int referencedOrdinal) {
                referencedClosureMatches.clear(referencedOrdinal);
            }
        };
        public static final TransitiveSetTraverserAction ADD_REFERENCING_OUTSIDE_CLOSURE = new TransitiveSetTraverserAction(){

            @Override
            public void foundReference(BitSet referencerClosureMatches, int referencerOrdinal, BitSet referencedClosureMatches, int referencedOrdinal) {
                referencerClosureMatches.set(referencerOrdinal);
            }
        };

        public void foundReference(BitSet var1, int var2, BitSet var3, int var4);
    }
}

