/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history.keyindex;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.util.ObjectInternPool;
import java.util.Arrays;

public class HollowOrdinalMapper {
    private int size = 0;
    private static final double LOAD_FACTOR = 0.7;
    private static final int STARTING_SIZE = 2069;
    private int[] hashToAssignedOrdinal = new int[2069];
    private int[][] fieldHashToObjectOrdinal;
    private IntList[][] fieldHashToAssignedOrdinal;
    private int[] assignedOrdinalToIndex;
    private final PrimaryKey primaryKey;
    private final int[][] keyFieldIndices;
    private final boolean[] keyFieldIsIndexed;
    private final HollowObjectSchema.FieldType[] keyFieldTypes;
    private final ObjectInternPool memoizedPool;

    public HollowOrdinalMapper(PrimaryKey primaryKey, boolean[] keyFieldIsIndexed, int[][] keyFieldIndices, HollowObjectSchema.FieldType[] keyFieldTypes) {
        this.fieldHashToObjectOrdinal = new int[primaryKey.numFields()][2069];
        this.fieldHashToAssignedOrdinal = new IntList[primaryKey.numFields()][2069];
        this.assignedOrdinalToIndex = new int[2069];
        Arrays.fill(this.hashToAssignedOrdinal, -1);
        for (int field = 0; field < primaryKey.numFields(); ++field) {
            Arrays.fill(this.fieldHashToObjectOrdinal[field], -1);
        }
        Arrays.fill(this.assignedOrdinalToIndex, -1);
        this.primaryKey = primaryKey;
        this.keyFieldIndices = keyFieldIndices;
        this.keyFieldIsIndexed = keyFieldIsIndexed;
        this.keyFieldTypes = keyFieldTypes;
        this.memoizedPool = new ObjectInternPool();
    }

    public void addMatches(int hashCode, Object objectToMatch, int field, HollowObjectSchema.FieldType type, IntList results) {
        IntList[] fieldHashes = this.fieldHashToAssignedOrdinal[field];
        int scanIndex = HollowOrdinalMapper.indexFromHash(hashCode, fieldHashes.length);
        if (fieldHashes[scanIndex] == null) {
            return;
        }
        for (int i = 0; i < fieldHashes[scanIndex].size(); ++i) {
            int assignedOrdinal = fieldHashes[scanIndex].get(i);
            Object object = this.getFieldObject(assignedOrdinal, field, type);
            if (!object.equals(objectToMatch)) continue;
            results.add(assignedOrdinal);
        }
    }

    public void writeKeyFieldHash(Object fieldObject, int assignedOrdinal, int fieldIdx) {
        if (!this.keyFieldIsIndexed[fieldIdx]) {
            return;
        }
        IntList[] fieldHashes = this.fieldHashToAssignedOrdinal[fieldIdx];
        int fieldHash = HollowOrdinalMapper.hashObject(fieldObject);
        int newIndex = HollowOrdinalMapper.indexFromHash(fieldHash, fieldHashes.length);
        if (fieldHashes[newIndex] == null) {
            fieldHashes[newIndex] = new IntList();
        }
        fieldHashes[newIndex].add(assignedOrdinal);
    }

    public void prepareForRead() {
        this.memoizedPool.prepareForRead();
    }

    public int findAssignedOrdinal(HollowObjectTypeReadState typeState, int keyOrdinal) {
        int hashedRecord = this.hashKeyRecord(typeState, keyOrdinal);
        int scanIndex = HollowOrdinalMapper.indexFromHash(hashedRecord, this.hashToAssignedOrdinal.length);
        while (this.hashToAssignedOrdinal[scanIndex] != -1) {
            if (this.recordsAreEqual(typeState, keyOrdinal, scanIndex)) {
                return this.hashToAssignedOrdinal[scanIndex];
            }
            scanIndex = (scanIndex + 1) % this.hashToAssignedOrdinal.length;
        }
        return -1;
    }

    private boolean recordsAreEqual(HollowObjectTypeReadState typeState, int keyOrdinal, int index) {
        for (int fieldIdx = 0; fieldIdx < this.primaryKey.numFields(); ++fieldIdx) {
            if (!this.keyFieldIsIndexed[fieldIdx]) continue;
            Object newFieldValue = this.readValueInState(typeState, keyOrdinal, fieldIdx);
            int existingFieldOrdinalValue = this.fieldHashToObjectOrdinal[fieldIdx][index];
            if (this.memoizedPool.ordinalInCurrentCycle(existingFieldOrdinalValue)) {
                return false;
            }
            Object existingFieldObjectValue = this.memoizedPool.getObject(existingFieldOrdinalValue, this.keyFieldTypes[fieldIdx]);
            if (newFieldValue.equals(existingFieldObjectValue)) continue;
            return false;
        }
        return true;
    }

    public boolean storeNewRecord(HollowObjectTypeReadState typeState, int ordinal, int assignedOrdinal) {
        int hashedRecord = this.hashKeyRecord(typeState, ordinal);
        if ((double)this.size / (double)this.hashToAssignedOrdinal.length > 0.7) {
            this.expandAndRehashTable();
        }
        int newIndex = HollowOrdinalMapper.indexFromHash(hashedRecord, this.hashToAssignedOrdinal.length);
        while (this.hashToAssignedOrdinal[newIndex] != -1) {
            if (this.recordsAreEqual(typeState, ordinal, newIndex)) {
                this.assignedOrdinalToIndex[assignedOrdinal] = newIndex;
                return false;
            }
            newIndex = (newIndex + 1) % this.hashToAssignedOrdinal.length;
        }
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            Object objectToHash = this.readValueInState(typeState, ordinal, i);
            this.writeKeyFieldHash(objectToHash, assignedOrdinal, i);
        }
        this.storeFieldObjects(typeState, ordinal, newIndex);
        this.hashToAssignedOrdinal[newIndex] = assignedOrdinal;
        this.assignedOrdinalToIndex[assignedOrdinal] = newIndex;
        ++this.size;
        return true;
    }

    private void storeFieldObjects(HollowObjectTypeReadState typeState, int ordinal, int index) {
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            int objectOrdinal;
            if (!this.keyFieldIsIndexed[i]) continue;
            Object objectToStore = this.readValueInState(typeState, ordinal, i);
            this.fieldHashToObjectOrdinal[i][index] = objectOrdinal = this.memoizedPool.writeAndGetOrdinal(objectToStore);
        }
    }

    private int[] getFieldOrdinals(int index) {
        int[] fieldObjects = new int[this.primaryKey.numFields()];
        for (int fieldIdx = 0; fieldIdx < this.primaryKey.numFields(); ++fieldIdx) {
            fieldObjects[fieldIdx] = this.fieldHashToObjectOrdinal[fieldIdx][index];
        }
        return fieldObjects;
    }

    private int hashFromIndex(int index) {
        int[] fieldOrdinals = this.getFieldOrdinals(index);
        Object[] fieldObjects = new Object[this.primaryKey.numFields()];
        for (int fieldIdx = 0; fieldIdx < this.primaryKey.numFields(); ++fieldIdx) {
            fieldObjects[fieldIdx] = this.memoizedPool.getObject(fieldOrdinals[fieldIdx], this.keyFieldTypes[fieldIdx]);
        }
        return this.hashKeyRecord(fieldObjects);
    }

    private void expandAndRehashTable() {
        int previousIndex;
        this.prepareForRead();
        int[] newTable = new int[this.hashToAssignedOrdinal.length * 2];
        Arrays.fill(newTable, -1);
        int[][] newFieldMappings = new int[this.primaryKey.numFields()][this.hashToAssignedOrdinal.length * 2];
        IntList[][] newFieldHashToOrdinal = new IntList[this.primaryKey.numFields()][this.hashToAssignedOrdinal.length * 2];
        this.assignedOrdinalToIndex = Arrays.copyOf(this.assignedOrdinalToIndex, this.hashToAssignedOrdinal.length * 2);
        for (int fieldIdx = 0; fieldIdx < this.primaryKey.numFields(); ++fieldIdx) {
            IntList[] hashToOrdinal;
            for (IntList ordinalList : hashToOrdinal = this.fieldHashToAssignedOrdinal[fieldIdx]) {
                if (ordinalList == null || ordinalList.size() == 0) continue;
                for (int i = 0; i < ordinalList.size(); ++i) {
                    int ordinal = ordinalList.get(i);
                    Object originalFieldObject = this.getFieldObject(ordinal, fieldIdx, this.keyFieldTypes[fieldIdx]);
                    int originalHash = HollowOrdinalMapper.hashObject(originalFieldObject);
                    int newIndex = HollowOrdinalMapper.indexFromHash(originalHash, newTable.length);
                    if (newFieldHashToOrdinal[fieldIdx][newIndex] == null) {
                        newFieldHashToOrdinal[fieldIdx][newIndex] = new IntList();
                    }
                    newFieldHashToOrdinal[fieldIdx][newIndex].add(ordinal);
                }
            }
        }
        for (int i = 0; i < this.hashToAssignedOrdinal.length; ++i) {
            if (this.hashToAssignedOrdinal[i] == -1) continue;
            int firstHash = this.hashFromIndex(i);
            int newIndex = this.rehashExistingRecord(newTable, firstHash, this.hashToAssignedOrdinal[i]);
            for (int fieldIdx = 0; fieldIdx < this.primaryKey.numFields(); ++fieldIdx) {
                newFieldMappings[fieldIdx][newIndex] = this.fieldHashToObjectOrdinal[fieldIdx][i];
            }
            this.hashToAssignedOrdinal[i] = newIndex;
        }
        for (int assignedOrdinal = 0; assignedOrdinal < this.assignedOrdinalToIndex.length && (previousIndex = this.assignedOrdinalToIndex[assignedOrdinal]) != -1; ++assignedOrdinal) {
            int newIndex;
            this.assignedOrdinalToIndex[assignedOrdinal] = newIndex = this.hashToAssignedOrdinal[previousIndex];
        }
        this.hashToAssignedOrdinal = newTable;
        this.fieldHashToObjectOrdinal = newFieldMappings;
        this.fieldHashToAssignedOrdinal = newFieldHashToOrdinal;
    }

    private int rehashExistingRecord(int[] newTable, int originalHash, int assignedOrdinal) {
        int newIndex = HollowOrdinalMapper.indexFromHash(originalHash, newTable.length);
        while (newTable[newIndex] != -1) {
            newIndex = (newIndex + 1) % newTable.length;
        }
        newTable[newIndex] = assignedOrdinal;
        return newIndex;
    }

    public Object getFieldObject(int assignedOrdinal, int fieldIndex, HollowObjectSchema.FieldType type) {
        int index = this.assignedOrdinalToIndex[assignedOrdinal];
        int fieldOrdinal = this.fieldHashToObjectOrdinal[fieldIndex][index];
        return this.memoizedPool.getObject(fieldOrdinal, type);
    }

    private int hashKeyRecord(HollowObjectTypeReadState typeState, int ordinal) {
        int hashCode = 0;
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            Object fieldObjectToHash = this.readValueInState(typeState, ordinal, i);
            int fieldHashCode = HollowReadFieldUtils.hashObject(fieldObjectToHash);
            hashCode = hashCode * 31 ^ fieldHashCode;
        }
        return HashCodes.hashInt(hashCode);
    }

    private int hashKeyRecord(Object[] objects) {
        int hashCode = 0;
        for (Object fieldObject : objects) {
            int fieldHashCode = HollowReadFieldUtils.hashObject(fieldObject);
            hashCode = hashCode * 31 ^ fieldHashCode;
        }
        return HashCodes.hashInt(hashCode);
    }

    public Object readValueInState(HollowObjectTypeReadState typeState, int ordinal, int fieldIdx) {
        HollowObjectSchema schema = typeState.getSchema();
        int lastFieldPath = this.keyFieldIndices[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.keyFieldIndices[fieldIdx][i];
            ordinal = typeState.readOrdinal(ordinal, fieldPosition);
            typeState = (HollowObjectTypeReadState)schema.getReferencedTypeState(fieldPosition);
            schema = typeState.getSchema();
        }
        return HollowReadFieldUtils.fieldValueObject(typeState, ordinal, this.keyFieldIndices[fieldIdx][lastFieldPath]);
    }

    private static int indexFromHash(int hashedValue, int length) {
        int modulus = hashedValue % length;
        return modulus < 0 ? modulus + length : modulus;
    }

    private static int hashObject(Object object) {
        return HashCodes.hashInt(HollowReadFieldUtils.hashObject(object));
    }
}

