/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.api.client.StackTraceRecorder;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import com.netflix.hollow.tools.history.IntMapOrdinalRemapper;

public abstract class HollowHistoricalTypeDataAccess
implements HollowTypeDataAccess {
    protected final HollowHistoricalStateDataAccess dataAccess;
    protected final HollowTypeReadState removedRecords;
    protected final IntMap ordinalRemap;
    protected final HollowSampler sampler;

    public HollowHistoricalTypeDataAccess(HollowHistoricalStateDataAccess dataAccess, HollowTypeReadState removedRecords, HollowSampler sampler) {
        IntMap ordinalRemap = null;
        if (dataAccess.getOrdinalMapping() instanceof IntMapOrdinalRemapper) {
            ordinalRemap = ((IntMapOrdinalRemapper)dataAccess.getOrdinalMapping()).getOrdinalRemapping(removedRecords.getSchema().getName());
        }
        this.dataAccess = dataAccess;
        this.ordinalRemap = ordinalRemap;
        this.removedRecords = removedRecords;
        this.sampler = sampler;
    }

    @Override
    public HollowHistoricalStateDataAccess getDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowSchema getSchema() {
        return this.removedRecords.getSchema();
    }

    protected boolean ordinalIsPresent(int ordinal) {
        return this.ordinalRemap == null || this.ordinalRemap.get(ordinal) != -1;
    }

    protected int getMappedOrdinal(int ordinal) {
        return this.ordinalRemap == null ? ordinal : this.ordinalRemap.get(ordinal);
    }

    @Override
    public HollowTypeReadState getTypeState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    protected void recordStackTrace() {
        StackTraceRecorder recorder = this.dataAccess.getStackTraceRecorder();
        if (recorder != null) {
            recorder.recordStackTrace(2);
        }
    }

    HollowTypeReadState getRemovedRecords() {
        return this.removedRecords;
    }

    IntMap getOrdinalRemap() {
        return this.ordinalRemap;
    }
}

