/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;

public class HistoricalPrimaryKeyMatcher {
    private final HollowObjectTypeDataAccess keyTypeAccess;
    private final int[][] fieldPathIndexes;
    private final HollowObjectSchema.FieldType[] fieldTypes;

    public HistoricalPrimaryKeyMatcher(HollowDataAccess dataAccess, PrimaryKey primaryKey) {
        this.fieldPathIndexes = new int[primaryKey.numFields()][];
        this.fieldTypes = new HollowObjectSchema.FieldType[primaryKey.numFields()];
        for (int i = 0; i < primaryKey.numFields(); ++i) {
            this.fieldPathIndexes[i] = primaryKey.getFieldPathIndex(dataAccess, i);
            this.fieldTypes[i] = primaryKey.getFieldType(dataAccess, i);
        }
        this.keyTypeAccess = (HollowObjectTypeDataAccess)dataAccess.getTypeDataAccess(primaryKey.getType());
    }

    public boolean keyMatches(int ordinal, Object ... keys) {
        if (keys.length != this.fieldPathIndexes.length) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.keyMatches(keys[i], ordinal, i)) continue;
            return false;
        }
        return true;
    }

    public boolean keyMatches(Object key, int ordinal, int fieldIdx) {
        HollowObjectTypeDataAccess dataAccess = this.keyTypeAccess;
        HollowObjectSchema schema = dataAccess.getSchema();
        int lastFieldPath = this.fieldPathIndexes[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.fieldPathIndexes[fieldIdx][i];
            ordinal = dataAccess.readOrdinal(ordinal, fieldPosition);
            dataAccess = (HollowObjectTypeDataAccess)dataAccess.getDataAccess().getTypeDataAccess(schema.getReferencedType(fieldPosition), ordinal);
            schema = dataAccess.getSchema();
        }
        int lastFieldIdx = this.fieldPathIndexes[fieldIdx][lastFieldPath];
        switch (this.fieldTypes[fieldIdx]) {
            case BOOLEAN: {
                Boolean b = dataAccess.readBoolean(ordinal, lastFieldIdx);
                if (b == key) {
                    return true;
                }
                if (b == null || key == null) {
                    return false;
                }
                return b.booleanValue() == ((Boolean)key).booleanValue();
            }
            case BYTES: {
                return Arrays.equals(dataAccess.readBytes(ordinal, lastFieldIdx), (byte[])key);
            }
            case DOUBLE: {
                return dataAccess.readDouble(ordinal, lastFieldIdx) == ((Double)key).doubleValue();
            }
            case FLOAT: {
                return dataAccess.readFloat(ordinal, lastFieldIdx) == ((Float)key).floatValue();
            }
            case INT: {
                return dataAccess.readInt(ordinal, lastFieldIdx) == ((Integer)key).intValue();
            }
            case LONG: {
                return dataAccess.readLong(ordinal, lastFieldIdx) == ((Long)key).longValue();
            }
            case REFERENCE: {
                return dataAccess.readOrdinal(ordinal, lastFieldIdx) == ((Integer)key).intValue();
            }
            case STRING: {
                return dataAccess.isStringFieldEqual(ordinal, lastFieldIdx, (String)key);
            }
        }
        throw new IllegalArgumentException("I don't know how to compare a " + (Object)((Object)this.fieldTypes[fieldIdx]));
    }

    public HollowObjectSchema.FieldType[] getFieldTypes() {
        return this.fieldTypes;
    }
}

