/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import java.util.Arrays;

public class DiffEqualOrdinalFilter {
    private final DiffEqualOrdinalMap equalOrdinalMap;
    private final IntList matchedFromOrdinals;
    private final IntList matchedToOrdinals;
    private final IntList unmatchedFromOrdinals;
    private final IntList unmatchedToOrdinals;
    private int[] hashedIdentityOrdinals;
    private int[] hashedIdentityOrdinalsCounts;
    private int[] matchedOrdinalsCounts;

    public DiffEqualOrdinalFilter(DiffEqualOrdinalMap equalityMapping) {
        this.equalOrdinalMap = equalityMapping;
        this.matchedFromOrdinals = new IntList();
        this.matchedToOrdinals = new IntList();
        this.unmatchedFromOrdinals = new IntList();
        this.unmatchedToOrdinals = new IntList();
        this.hashedIdentityOrdinals = new int[0];
        this.hashedIdentityOrdinalsCounts = new int[0];
        this.matchedOrdinalsCounts = new int[0];
    }

    public void filter(IntList fromOrdinals, IntList toOrdinals) {
        int bucket;
        int hashCode;
        int identity;
        int i;
        this.matchedFromOrdinals.clear();
        this.matchedToOrdinals.clear();
        this.unmatchedFromOrdinals.clear();
        this.unmatchedToOrdinals.clear();
        int hashSize = 1 << 32 - Integer.numberOfLeadingZeros(fromOrdinals.size() * 2 - 1);
        if (this.hashedIdentityOrdinals.length < hashSize) {
            this.hashedIdentityOrdinals = new int[hashSize];
            this.hashedIdentityOrdinalsCounts = new int[hashSize];
            this.matchedOrdinalsCounts = new int[hashSize];
        }
        Arrays.fill(this.hashedIdentityOrdinals, -1);
        Arrays.fill(this.hashedIdentityOrdinalsCounts, 0);
        Arrays.fill(this.matchedOrdinalsCounts, 0);
        for (i = 0; i < fromOrdinals.size(); ++i) {
            identity = this.equalOrdinalMap.getIdentityFromOrdinal(fromOrdinals.get(i));
            if (identity == -1) continue;
            hashCode = HashCodes.hashInt(identity);
            bucket = hashCode & this.hashedIdentityOrdinals.length - 1;
            while (this.hashedIdentityOrdinals[bucket] != -1 && this.hashedIdentityOrdinals[bucket] != identity) {
                bucket = bucket + 1 & this.hashedIdentityOrdinals.length - 1;
            }
            this.hashedIdentityOrdinals[bucket] = identity;
            int n = bucket;
            this.hashedIdentityOrdinalsCounts[n] = this.hashedIdentityOrdinalsCounts[n] + 1;
        }
        for (i = 0; i < toOrdinals.size(); ++i) {
            identity = this.equalOrdinalMap.getIdentityToOrdinal(toOrdinals.get(i));
            if (identity != -1) {
                hashCode = HashCodes.hashInt(identity);
                bucket = hashCode & this.hashedIdentityOrdinals.length - 1;
                while (this.hashedIdentityOrdinals[bucket] != -1 && this.hashedIdentityOrdinals[bucket] != identity) {
                    bucket = bucket + 1 & this.hashedIdentityOrdinals.length - 1;
                }
                if (this.hashedIdentityOrdinals[bucket] == identity && this.matchedOrdinalsCounts[bucket] < this.hashedIdentityOrdinalsCounts[bucket]) {
                    int n = bucket;
                    this.matchedOrdinalsCounts[n] = this.matchedOrdinalsCounts[n] + 1;
                    this.matchedToOrdinals.add(toOrdinals.get(i));
                    continue;
                }
                this.unmatchedToOrdinals.add(toOrdinals.get(i));
                continue;
            }
            this.unmatchedToOrdinals.add(toOrdinals.get(i));
        }
        for (i = 0; i < fromOrdinals.size(); ++i) {
            identity = this.equalOrdinalMap.getIdentityFromOrdinal(fromOrdinals.get(i));
            if (identity != -1) {
                hashCode = HashCodes.hashInt(identity);
                bucket = hashCode & this.hashedIdentityOrdinals.length - 1;
                while (this.hashedIdentityOrdinals[bucket] != identity) {
                    bucket = bucket + 1 & this.hashedIdentityOrdinals.length - 1;
                }
                if (this.matchedOrdinalsCounts[bucket] > 0) {
                    int n = bucket;
                    this.matchedOrdinalsCounts[n] = this.matchedOrdinalsCounts[n] - 1;
                    this.matchedFromOrdinals.add(fromOrdinals.get(i));
                    continue;
                }
                this.unmatchedFromOrdinals.add(fromOrdinals.get(i));
                continue;
            }
            this.unmatchedFromOrdinals.add(fromOrdinals.get(i));
        }
    }

    public IntList getMatchedFromOrdinals() {
        return this.matchedFromOrdinals;
    }

    public IntList getMatchedToOrdinals() {
        return this.matchedToOrdinals;
    }

    public IntList getUnmatchedFromOrdinals() {
        return this.unmatchedFromOrdinals;
    }

    public IntList getUnmatchedToOrdinals() {
        return this.unmatchedToOrdinals;
    }
}

