/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff;

import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.LongList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class HollowDiffMatcher {
    private final List<String> matchPaths = new ArrayList<String>();
    private final HollowObjectTypeReadState fromTypeState;
    private final HollowObjectTypeReadState toTypeState;
    private final LongList matchedOrdinals;
    private final IntList extraInFrom;
    private final IntList extraInTo;
    private HollowPrimaryKeyIndex fromIdx;
    private HollowPrimaryKeyIndex toIdx;

    public HollowDiffMatcher(HollowObjectTypeReadState fromTypeState, HollowObjectTypeReadState toTypeState) {
        this.fromTypeState = fromTypeState;
        this.toTypeState = toTypeState;
        this.matchedOrdinals = new LongList();
        this.extraInFrom = new IntList();
        this.extraInTo = new IntList();
    }

    public void addMatchPath(String path) {
        this.matchPaths.add(path);
    }

    public List<String> getMatchPaths() {
        return this.matchPaths;
    }

    public void calculateMatches() {
        if (this.fromTypeState == null) {
            this.toTypeState.getPopulatedOrdinals().stream().forEach(i -> this.extraInTo.add(i));
            return;
        }
        if (this.toTypeState == null) {
            this.fromTypeState.getPopulatedOrdinals().stream().forEach(i -> this.extraInFrom.add(i));
            return;
        }
        if (this.matchPaths == null || this.matchPaths.isEmpty()) {
            this.toTypeState.getPopulatedOrdinals().stream().forEach(i -> this.extraInTo.add(i));
            this.fromTypeState.getPopulatedOrdinals().stream().forEach(i -> this.extraInFrom.add(i));
            return;
        }
        this.fromIdx = new HollowPrimaryKeyIndex(this.fromTypeState.getStateEngine(), this.fromTypeState.getSchema().getName(), this.matchPaths.toArray(new String[this.matchPaths.size()]));
        this.toIdx = new HollowPrimaryKeyIndex(this.toTypeState.getStateEngine(), this.toTypeState.getSchema().getName(), this.matchPaths.toArray(new String[this.matchPaths.size()]));
        BitSet fromPopulatedOrdinals = this.fromTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        BitSet fromUnmatchedOrdinals = new BitSet(fromPopulatedOrdinals.length());
        fromUnmatchedOrdinals.or(fromPopulatedOrdinals);
        BitSet toPopulatedOrdinals = this.toTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        int candidateToMatchOrdinal = toPopulatedOrdinals.nextSetBit(0);
        while (candidateToMatchOrdinal != -1) {
            Object[] key = this.toIdx.getRecordKey(candidateToMatchOrdinal);
            int matchedOrdinal = -1;
            try {
                matchedOrdinal = this.fromIdx.getMatchingOrdinal(key);
            }
            catch (NullPointerException ex) {
                throw new RuntimeException("Error fetching matching ordinal for null type " + this.toTypeState.getSchema().getName() + " with key field values " + Arrays.asList(key) + " at ordinal : " + candidateToMatchOrdinal + "with stack trace ", ex);
            }
            if (matchedOrdinal != -1) {
                this.matchedOrdinals.add((long)matchedOrdinal << 32 | (long)candidateToMatchOrdinal);
                fromUnmatchedOrdinals.clear(matchedOrdinal);
            } else {
                this.extraInTo.add(candidateToMatchOrdinal);
            }
            candidateToMatchOrdinal = toPopulatedOrdinals.nextSetBit(candidateToMatchOrdinal + 1);
        }
        int unmatchedFromOrdinal = fromUnmatchedOrdinals.nextSetBit(0);
        while (unmatchedFromOrdinal != -1) {
            this.extraInFrom.add(unmatchedFromOrdinal);
            unmatchedFromOrdinal = fromUnmatchedOrdinals.nextSetBit(unmatchedFromOrdinal + 1);
        }
    }

    public LongList getMatchedOrdinals() {
        return this.matchedOrdinals;
    }

    public IntList getExtraInFrom() {
        return this.extraInFrom;
    }

    public IntList getExtraInTo() {
        return this.extraInTo;
    }

    public String getKeyDisplayString(HollowObjectTypeReadState state, int ordinal) {
        Object[] key = null;
        if (state == this.fromTypeState && this.fromIdx != null) {
            key = this.fromIdx.getRecordKey(ordinal);
        } else if (state == this.toTypeState && this.toIdx != null) {
            key = this.toIdx.getRecordKey(ordinal);
        }
        if (key == null) {
            return "ORDINAL:" + ordinal;
        }
        return this.keyDisplayString(key);
    }

    private String keyDisplayString(Object[] key) {
        StringBuilder sb = new StringBuilder(key[0].toString());
        for (int i = 1; i < key.length; ++i) {
            sb.append(" ");
            sb.append(key[i].toString());
        }
        return sb.toString();
    }
}

