/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.copy;

import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIteratorImpl;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;
import com.netflix.hollow.core.write.HollowMapWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.OrdinalRemapper;

public class HollowMapCopier
extends HollowRecordCopier {
    public HollowMapCopier(HollowMapTypeReadState readTypeState, OrdinalRemapper ordinalRemapper, boolean preserveHashPositions) {
        super(readTypeState, new HollowMapWriteRecord(preserveHashPositions ? HollowHashableWriteRecord.HashBehavior.UNMIXED_HASHES : HollowHashableWriteRecord.HashBehavior.MIXED_HASHES), ordinalRemapper, preserveHashPositions);
    }

    @Override
    public HollowWriteRecord copy(int ordinal) {
        HollowMapWriteRecord rec = this.rec();
        rec.reset();
        HollowMapEntryOrdinalIterator iter = this.readState().ordinalIterator(ordinal);
        String keyType = this.readState().getSchema().getKeyType();
        String valueType = this.readState().getSchema().getValueType();
        while (iter.next()) {
            int remappedKeyOrdinal = this.ordinalRemapper.getMappedOrdinal(keyType, iter.getKey());
            int remappedValueOrdinal = this.ordinalRemapper.getMappedOrdinal(valueType, iter.getValue());
            int hashCode = this.preserveHashPositions ? ((HollowMapEntryOrdinalIteratorImpl)iter).getCurrentBucket() : remappedKeyOrdinal;
            rec.addEntry(remappedKeyOrdinal, remappedValueOrdinal, hashCode);
        }
        return rec;
    }

    private HollowMapTypeReadState readState() {
        return (HollowMapTypeReadState)this.readTypeState;
    }

    private HollowMapWriteRecord rec() {
        return (HollowMapWriteRecord)this.writeRecord;
    }
}

