/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.ByteArrayOrdinalMap;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.encoding.ZigZag;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEngine;

class HollowWriteStateEnginePrimaryKeyHasher {
    private final HollowObjectTypeWriteState[][] typeStates;
    private final int[][] fieldPathIndexes;

    public HollowWriteStateEnginePrimaryKeyHasher(PrimaryKey primaryKey, HollowWriteStateEngine writeEngine) {
        HollowWriteStateEngine stateEngine = writeEngine;
        HollowObjectTypeWriteState rootTypeWriteState = (HollowObjectTypeWriteState)writeEngine.getTypeState(primaryKey.getType());
        this.fieldPathIndexes = new int[primaryKey.numFields()][];
        this.typeStates = new HollowObjectTypeWriteState[primaryKey.numFields()][];
        for (int i = 0; i < primaryKey.numFields(); ++i) {
            this.fieldPathIndexes[i] = primaryKey.getFieldPathIndex(stateEngine, i);
            this.typeStates[i] = new HollowObjectTypeWriteState[this.fieldPathIndexes[i].length];
            this.typeStates[i][0] = rootTypeWriteState;
            for (int j = 1; j < this.typeStates[i].length; ++j) {
                String referencedType = this.typeStates[i][j - 1].getSchema().getReferencedType(this.fieldPathIndexes[i][j - 1]);
                this.typeStates[i][j] = (HollowObjectTypeWriteState)stateEngine.getTypeState(referencedType);
            }
        }
    }

    public int getRecordHash(int ordinal) {
        int hash = 0;
        for (int i = 0; i < this.fieldPathIndexes.length; ++i) {
            hash *= 31;
            hash ^= this.hashValue(ordinal, i);
        }
        return hash;
    }

    private int hashValue(int ordinal, int fieldIdx) {
        int lastFieldPath = this.fieldPathIndexes[fieldIdx].length - 1;
        for (int i = 0; i < lastFieldPath; ++i) {
            int fieldPosition = this.fieldPathIndexes[fieldIdx][i];
            ByteArrayOrdinalMap ordinalMap = this.typeStates[fieldIdx][i].ordinalMap;
            long offset = ordinalMap.getPointerForData(ordinal);
            SegmentedByteArray recordDataArray = ordinalMap.getByteData().getUnderlyingArray();
            offset = this.navigateToField(this.typeStates[fieldIdx][i].getSchema(), fieldPosition, recordDataArray, offset);
            ordinal = VarInt.readVInt(recordDataArray, offset);
        }
        int fieldPosition = this.fieldPathIndexes[fieldIdx][lastFieldPath];
        ByteArrayOrdinalMap ordinalMap = this.typeStates[fieldIdx][lastFieldPath].ordinalMap;
        long offset = ordinalMap.getPointerForData(ordinal);
        SegmentedByteArray recordDataArray = ordinalMap.getByteData().getUnderlyingArray();
        HollowObjectSchema schema = this.typeStates[fieldIdx][lastFieldPath].getSchema();
        offset = this.navigateToField(schema, fieldPosition, recordDataArray, offset);
        return HashCodes.hashInt(this.fieldHashCode(schema, fieldPosition, recordDataArray, offset));
    }

    private long navigateToField(HollowObjectSchema schema, int fieldIdx, SegmentedByteArray data, long offset) {
        block7: for (int i = 0; i < fieldIdx; ++i) {
            switch (schema.getFieldType(i)) {
                case INT: 
                case LONG: 
                case REFERENCE: {
                    offset += (long)VarInt.nextVLongSize(data, offset);
                    continue block7;
                }
                case BYTES: 
                case STRING: {
                    int fieldLength = VarInt.readVInt(data, offset);
                    offset += (long)VarInt.sizeOfVInt(fieldLength);
                    offset += (long)fieldLength;
                    continue block7;
                }
                case BOOLEAN: {
                    ++offset;
                    continue block7;
                }
                case DOUBLE: {
                    offset += 8L;
                    continue block7;
                }
                case FLOAT: {
                    offset += 4L;
                }
            }
        }
        return offset;
    }

    private int fieldHashCode(HollowObjectSchema schema, int fieldIdx, SegmentedByteArray data, long offset) {
        switch (schema.getFieldType(fieldIdx)) {
            case INT: {
                if (VarInt.readVNull(data, offset)) {
                    return 0;
                }
                int intVal = VarInt.readVInt(data, offset);
                intVal = ZigZag.decodeInt(intVal);
                return intVal;
            }
            case LONG: {
                if (VarInt.readVNull(data, offset)) {
                    return 0;
                }
                long longVal = VarInt.readVLong(data, offset);
                longVal = ZigZag.decodeLong(longVal);
                return (int)(longVal ^ longVal >>> 32);
            }
            case REFERENCE: {
                return VarInt.readVInt(data, offset);
            }
            case BYTES: {
                int byteLen = VarInt.readVInt(data, offset);
                return HashCodes.hashCode(data, offset += (long)VarInt.sizeOfVInt(byteLen), byteLen);
            }
            case STRING: {
                int strByteLen = VarInt.readVInt(data, offset);
                return this.getNaturalStringHashCode(data, offset += (long)VarInt.sizeOfVInt(strByteLen), strByteLen);
            }
            case BOOLEAN: {
                if (VarInt.readVNull(data, offset)) {
                    return 0;
                }
                return data.get(offset) == 1 ? 1231 : 1237;
            }
            case DOUBLE: {
                long longBits = data.readLongBits(offset);
                return (int)(longBits ^ longBits >>> 32);
            }
            case FLOAT: {
                return data.readIntBits(offset);
            }
        }
        throw new IllegalArgumentException("Schema " + schema.getName() + " has unknown field type for field " + schema.getFieldName(fieldIdx) + ": " + (Object)((Object)schema.getFieldType(fieldIdx)));
    }

    private int getNaturalStringHashCode(SegmentedByteArray data, long offset, int len) {
        int hashCode = 0;
        long endOffset = (long)len + offset;
        while (offset < endOffset) {
            int ch = VarInt.readVInt(data, offset);
            hashCode = hashCode * 31 + ch;
            offset += (long)VarInt.sizeOfVInt(ch);
        }
        return hashCode;
    }
}

