/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HollowMapWriteRecord
implements HollowHashableWriteRecord {
    private static final Comparator<HollowMapEntry> MAP_ENTRY_COMPARATOR = new Comparator<HollowMapEntry>(){

        @Override
        public int compare(HollowMapEntry o1, HollowMapEntry o2) {
            int res = o1.getKeyOrdinal() - o2.getKeyOrdinal();
            if (res == 0) {
                res = o1.getValueOrdinal() - o2.getValueOrdinal();
            }
            return res;
        }
    };
    private final List<HollowMapEntry> entryList = new ArrayList<HollowMapEntry>();
    private final HollowHashableWriteRecord.HashBehavior defaultHashBehavior;

    public HollowMapWriteRecord() {
        this(HollowHashableWriteRecord.HashBehavior.MIXED_HASHES);
    }

    public HollowMapWriteRecord(HollowHashableWriteRecord.HashBehavior defaultHashBehavior) {
        this.defaultHashBehavior = defaultHashBehavior;
    }

    public void addEntry(int keyOrdinal, int valueOrdinal) {
        this.addEntry(keyOrdinal, valueOrdinal, keyOrdinal);
    }

    public void addEntry(int keyOrdinal, int valueOrdinal, int hashCode) {
        this.entryList.add(new HollowMapEntry(keyOrdinal, valueOrdinal, hashCode));
    }

    @Override
    public void writeDataTo(ByteDataArray buf) {
        this.writeDataTo(buf, this.defaultHashBehavior);
    }

    @Override
    public void writeDataTo(ByteDataArray buf, HollowHashableWriteRecord.HashBehavior hashBehavior) {
        Collections.sort(this.entryList, MAP_ENTRY_COMPARATOR);
        VarInt.writeVInt(buf, this.entryList.size());
        int hashTableSize = HashCodes.hashTableSize(this.entryList.size());
        int bucketMask = hashTableSize - 1;
        int previousKeyOrdinal = 0;
        for (int i = 0; i < this.entryList.size(); ++i) {
            HollowMapEntry entry = this.entryList.get(i);
            VarInt.writeVInt(buf, entry.getKeyOrdinal() - previousKeyOrdinal);
            VarInt.writeVInt(buf, entry.getValueOrdinal());
            if (hashBehavior != HollowHashableWriteRecord.HashBehavior.IGNORED_HASHES) {
                int hashCode = entry.getHashCode();
                if (hashBehavior == HollowHashableWriteRecord.HashBehavior.MIXED_HASHES) {
                    hashCode = HashCodes.hashInt(hashCode);
                }
                int bucketToHashTo = hashCode & bucketMask;
                VarInt.writeVInt(buf, bucketToHashTo);
            }
            previousKeyOrdinal = entry.getKeyOrdinal();
        }
    }

    @Override
    public void reset() {
        this.entryList.clear();
    }

    private static class HollowMapEntry {
        private final int keyOrdinal;
        private final int valueOrdinal;
        private final int hashCode;

        public HollowMapEntry(int keyOrdinal, int valueOrdinal, int hashCode) {
            this.keyOrdinal = keyOrdinal;
            this.valueOrdinal = valueOrdinal;
            this.hashCode = hashCode;
        }

        public int getKeyOrdinal() {
            return this.keyOrdinal;
        }

        public int getValueOrdinal() {
            return this.valueOrdinal;
        }

        public int getHashCode() {
            return this.hashCode;
        }
    }
}

