/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import java.util.BitSet;

public class RemovedOrdinalIterator {
    private final BitSet previousOrdinals;
    private final BitSet populatedOrdinals;
    private final int previousOrdinalsLength;
    private int ordinal = -1;

    public RemovedOrdinalIterator(PopulatedOrdinalListener listener) {
        this(listener.getPreviousOrdinals(), listener.getPopulatedOrdinals());
    }

    public RemovedOrdinalIterator(BitSet previousOrdinals, BitSet populatedOrdinals) {
        this(previousOrdinals, populatedOrdinals, false);
    }

    public RemovedOrdinalIterator(PopulatedOrdinalListener listener, boolean flip) {
        this(listener.getPreviousOrdinals(), listener.getPopulatedOrdinals(), flip);
    }

    public RemovedOrdinalIterator(BitSet previousOrdinals, BitSet populatedOrdinals, boolean flip) {
        if (!flip) {
            this.previousOrdinals = previousOrdinals;
            this.populatedOrdinals = populatedOrdinals;
            this.previousOrdinalsLength = previousOrdinals.length();
        } else {
            this.previousOrdinals = populatedOrdinals;
            this.populatedOrdinals = previousOrdinals;
            this.previousOrdinalsLength = populatedOrdinals.length();
        }
    }

    public int next() {
        while (this.ordinal < this.previousOrdinalsLength) {
            this.ordinal = this.populatedOrdinals.nextClearBit(this.ordinal + 1);
            if (!this.previousOrdinals.get(this.ordinal)) continue;
            return this.ordinal;
        }
        return -1;
    }

    public void reset() {
        this.ordinal = -1;
    }

    public int countTotal() {
        int bookmark = this.ordinal;
        this.reset();
        int count = 0;
        while (this.next() != -1) {
            ++count;
        }
        this.ordinal = bookmark;
        return count;
    }
}

