/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.type.delegate;

import com.netflix.hollow.api.custom.HollowTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowCachedDelegate;
import com.netflix.hollow.api.objects.delegate.HollowObjectAbstractDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.type.DoubleTypeAPI;
import com.netflix.hollow.core.type.delegate.DoubleDelegate;

public class DoubleDelegateCachedImpl
extends HollowObjectAbstractDelegate
implements HollowCachedDelegate,
DoubleDelegate {
    private final Double value;
    private DoubleTypeAPI typeAPI;

    public DoubleDelegateCachedImpl(DoubleTypeAPI typeAPI, int ordinal) {
        this.value = typeAPI.getValueBoxed(ordinal);
        this.typeAPI = typeAPI;
    }

    @Override
    public double getValue(int ordinal) {
        if (this.value == null) {
            return Double.NaN;
        }
        return this.value;
    }

    @Override
    public Double getValueBoxed(int ordinal) {
        return this.value;
    }

    @Override
    public HollowObjectSchema getSchema() {
        return this.typeAPI.getTypeDataAccess().getSchema();
    }

    @Override
    public HollowObjectTypeDataAccess getTypeDataAccess() {
        return this.typeAPI.getTypeDataAccess();
    }

    @Override
    public DoubleTypeAPI getTypeAPI() {
        return this.typeAPI;
    }

    @Override
    public void updateTypeAPI(HollowTypeAPI typeAPI) {
        this.typeAPI = (DoubleTypeAPI)typeAPI;
    }
}

