/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class HollowSchemaParser {
    private static final Logger log = Logger.getLogger(HollowSchemaParser.class.getName());

    public static List<HollowSchema> parseCollectionOfSchemas(Reader reader) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        HollowSchemaParser.configureTokenizer(tokenizer);
        ArrayList<HollowSchema> schemaList = new ArrayList<HollowSchema>();
        HollowSchema schema = HollowSchemaParser.parseSchema(tokenizer);
        while (schema != null) {
            schemaList.add(schema);
            schema = HollowSchemaParser.parseSchema(tokenizer);
        }
        return schemaList;
    }

    public static List<HollowSchema> parseCollectionOfSchemas(String schemas) throws IOException {
        return HollowSchemaParser.parseCollectionOfSchemas(new StringReader(schemas));
    }

    public static HollowSchema parseSchema(String schema) throws IOException {
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(schema));
        HollowSchemaParser.configureTokenizer(tokenizer);
        return HollowSchemaParser.parseSchema(tokenizer);
    }

    private static HollowSchema parseSchema(StreamTokenizer tokenizer) throws IOException {
        int tok = tokenizer.nextToken();
        while (tok != -3) {
            if (tok == -1) {
                return null;
            }
            tok = tokenizer.nextToken();
        }
        String typeName = tokenizer.sval;
        tok = tokenizer.nextToken();
        if (tok == -3) {
            if ("List".equals(tokenizer.sval)) {
                return HollowSchemaParser.parseListSchema(typeName, tokenizer);
            }
            if ("Set".equals(tokenizer.sval)) {
                return HollowSchemaParser.parseSetSchema(typeName, tokenizer);
            }
            if ("Map".equals(tokenizer.sval)) {
                return HollowSchemaParser.parseMapSchema(typeName, tokenizer);
            }
            throw new IOException("Invalid syntax: expected one of '{', 'List', 'Set', or 'Map' after type declaration for '" + typeName + "'");
        }
        return HollowSchemaParser.parseObjectSchema(typeName, tokenizer);
    }

    private static HollowObjectSchema parseObjectSchema(String typeName, StreamTokenizer tokenizer) throws IOException {
        String[] keyFieldPaths = HollowSchemaParser.parsePrimaryKey(tokenizer);
        if (tokenizer.ttype != 123) {
            throw new IOException("Invalid syntax: expecting '{' for '" + typeName + "'");
        }
        int tok = tokenizer.nextToken();
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.ttype != 125) {
            if (tok != -3) {
                throw new IOException("Invalid syntax, expected field type: " + typeName);
            }
            tokens.add(tokenizer.sval);
            tokenizer.nextToken();
            if (tok != -3) {
                throw new IOException("Invalid syntax, expected field name: " + typeName);
            }
            String fieldName = tokenizer.sval;
            tokens.add(fieldName);
            tokenizer.nextToken();
            if (tokenizer.ttype != 59) {
                throw new IOException("Invalid syntax, expected semicolon: " + typeName + "." + fieldName);
            }
            tokenizer.nextToken();
        }
        HollowObjectSchema schema = new HollowObjectSchema(typeName, tokens.size() / 2, keyFieldPaths);
        for (int i = 0; i < tokens.size(); i += 2) {
            String fieldType = (String)tokens.get(i);
            if ("int".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.INT);
                continue;
            }
            if ("long".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.LONG);
                continue;
            }
            if ("float".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.FLOAT);
                continue;
            }
            if ("double".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.DOUBLE);
                continue;
            }
            if ("boolean".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.BOOLEAN);
                continue;
            }
            if ("string".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.STRING);
                continue;
            }
            if ("bytes".equals(fieldType)) {
                schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.BYTES);
                continue;
            }
            schema.addField((String)tokens.get(i + 1), HollowObjectSchema.FieldType.REFERENCE, fieldType);
        }
        return schema;
    }

    private static HollowListSchema parseListSchema(String typeName, StreamTokenizer tokenizer) throws IOException {
        int tok = tokenizer.nextToken();
        if (tokenizer.ttype != 60) {
            throw new IOException("Invalid Syntax: Expected '<' after 'List' for type " + typeName);
        }
        tok = tokenizer.nextToken();
        if (tok != -3) {
            log.warning("Invalid Syntax: Expected element type declaration: " + typeName);
        }
        String elementType = tokenizer.sval;
        tok = tokenizer.nextToken();
        if (tokenizer.ttype != 62) {
            throw new IOException("Invalid Syntax: Expected '>' element type declaration: " + typeName);
        }
        tok = tokenizer.nextToken();
        if (tokenizer.ttype != 59) {
            throw new IOException("Invalid Syntax: Expected semicolon after List schema declaration: " + typeName);
        }
        return new HollowListSchema(typeName, elementType);
    }

    private static HollowSetSchema parseSetSchema(String typeName, StreamTokenizer tokenizer) throws IOException {
        int tok = tokenizer.nextToken();
        if (tokenizer.ttype != 60) {
            throw new IOException("Invalid Syntax: Expected '<' after 'Set' for type " + typeName);
        }
        tok = tokenizer.nextToken();
        if (tok != -3) {
            log.warning("Invalid Syntax: Expected element type declaration: " + typeName);
        }
        String elementType = tokenizer.sval;
        tok = tokenizer.nextToken();
        if (tokenizer.ttype != 62) {
            throw new IOException("Invalid Syntax: Expected '>' element type declaration: " + typeName);
        }
        tok = tokenizer.nextToken();
        String[] hashKeyPaths = HollowSchemaParser.parseHashKey(tokenizer);
        if (tokenizer.ttype != 59) {
            throw new IOException("Invalid Syntax: Expected semicolon after Set schema declaration: " + typeName);
        }
        return new HollowSetSchema(typeName, elementType, hashKeyPaths);
    }

    private static HollowMapSchema parseMapSchema(String typeName, StreamTokenizer tokenizer) throws IOException {
        int tok = tokenizer.nextToken();
        if (tokenizer.ttype != 60) {
            throw new IOException("Invalid Syntax: Expected '<' after 'Map' for type " + typeName);
        }
        tok = tokenizer.nextToken();
        if (tok != -3) {
            log.warning("Invalid Syntax: Expected element type declaration: " + typeName);
        }
        String keyType = tokenizer.sval;
        tok = tokenizer.nextToken();
        if (tokenizer.ttype != 44) {
            throw new IOException("Invalid Syntax: Expected ',' after key type declaration: " + typeName);
        }
        tok = tokenizer.nextToken();
        if (tok != -3) {
            log.warning("Invalid Syntax: Expected value type declaration: " + typeName);
        }
        String valueType = tokenizer.sval;
        tok = tokenizer.nextToken();
        if (tokenizer.ttype != 62) {
            throw new IOException("Invalid Syntax: Expected '>' after value type declaration: " + typeName);
        }
        tok = tokenizer.nextToken();
        String[] hashKeyPaths = HollowSchemaParser.parseHashKey(tokenizer);
        if (tokenizer.ttype != 59) {
            throw new IOException("Invalid Syntax: Expected semicolon after Map schema declaration: " + typeName);
        }
        return new HollowMapSchema(typeName, keyType, valueType, hashKeyPaths);
    }

    private static String[] parseHashKey(StreamTokenizer tokenizer) throws IOException {
        return HollowSchemaParser.parseKeyFieldPaths(tokenizer, "HashKey");
    }

    private static String[] parsePrimaryKey(StreamTokenizer tokenizer) throws IOException {
        return HollowSchemaParser.parseKeyFieldPaths(tokenizer, "PrimaryKey");
    }

    private static String[] parseKeyFieldPaths(StreamTokenizer tokenizer, String annotationName) throws IOException {
        if (tokenizer.ttype != 64) {
            return new String[0];
        }
        ArrayList<String> fieldPaths = new ArrayList<String>();
        int tok = tokenizer.nextToken();
        if (tok != -3 || !annotationName.equals(tokenizer.sval)) {
            throw new IOException("Invalid Syntax: Invalid  @" + tokenizer.sval + " annotation, expecting @" + annotationName + " declaraction");
        }
        tok = tokenizer.nextToken();
        if (tokenizer.ttype != 40) {
            throw new IOException("Expected open parenthesis '(' after @" + annotationName + " declaration");
        }
        tok = tokenizer.nextToken();
        while (tokenizer.ttype != 41) {
            if (tok != -3) {
                throw new IOException("Invalid field declaration inside @" + annotationName + "spec");
            }
            fieldPaths.add(tokenizer.sval);
            tok = tokenizer.nextToken();
            if (tokenizer.ttype == 44) {
                tok = tokenizer.nextToken();
                continue;
            }
            if (tokenizer.ttype == 41) continue;
            throw new IOException("Invalid char inside @" + annotationName + " spec");
        }
        tok = tokenizer.nextToken();
        return fieldPaths.toArray(new String[fieldPaths.size()]);
    }

    private static void configureTokenizer(StreamTokenizer tokenizer) {
        tokenizer.wordChars(95, 95);
        tokenizer.slashSlashComments(true);
        tokenizer.slashStarComments(true);
    }
}

