/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.filter;

import com.netflix.hollow.Internal;
import com.netflix.hollow.core.read.filter.TypeActions;
import com.netflix.hollow.core.read.filter.TypeFilter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

@Internal
class ResolvedTypeFilter
implements TypeFilter {
    private final Map<String, TypeActions> actionsMap;

    ResolvedTypeFilter(Map<String, TypeActions> actionsMap) {
        this.actionsMap = Collections.unmodifiableMap(new LinkedHashMap<String, TypeActions>(actionsMap));
    }

    @Override
    public boolean includes(String type) {
        Objects.requireNonNull(type, "type name required");
        TypeActions ta = this.actionsMap.get(type);
        return ta != null && ta.actions().values().stream().anyMatch(action -> action.included);
    }

    @Override
    public boolean includes(String type, String field) {
        Objects.requireNonNull(type, "type name required");
        Objects.requireNonNull(field, "field name required");
        TypeActions ta = this.actionsMap.get(type);
        return ta != null && (ta.action().included || ta.action((String)field).included);
    }
}

