/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.filter;

import com.netflix.hollow.core.read.filter.TypeFilter;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Deprecated
public class HollowFilterConfig
implements TypeFilter {
    private final ObjectFilterConfig INCLUDE_ALL = new ObjectFilterConfig(Boolean.TRUE);
    private final ObjectFilterConfig INCLUDE_NONE = new ObjectFilterConfig(Boolean.FALSE);
    private final boolean isExcludeFilter;
    private final Set<String> specifiedTypes;
    private final Map<String, ObjectFilterConfig> specifiedFieldConfigs;

    public HollowFilterConfig() {
        this(false);
    }

    public HollowFilterConfig(boolean isExcludeFilter) {
        this.isExcludeFilter = isExcludeFilter;
        this.specifiedTypes = new HashSet<String>();
        this.specifiedFieldConfigs = new HashMap<String, ObjectFilterConfig>();
    }

    public void addType(String type) {
        this.specifiedTypes.add(type);
    }

    public void addTypeRecursive(String type, Collection<HollowSchema> schemas) {
        this.addTypeRecursive(type, this.mapSchemas(schemas));
    }

    public void addTypeRecursive(String type, Map<String, HollowSchema> schemas) {
        this.addType(type);
        HollowSchema schema = schemas.get(type);
        switch (schema.getSchemaType()) {
            case OBJECT: {
                HollowObjectSchema objSchema = (HollowObjectSchema)schema;
                for (int i = 0; i < objSchema.numFields(); ++i) {
                    if (objSchema.getFieldType(i) != HollowObjectSchema.FieldType.REFERENCE) continue;
                    this.addTypeRecursive(objSchema.getReferencedType(i), schemas);
                }
                break;
            }
            case MAP: {
                this.addTypeRecursive(((HollowMapSchema)schema).getKeyType(), schemas);
                this.addTypeRecursive(((HollowMapSchema)schema).getValueType(), schemas);
                break;
            }
            case LIST: 
            case SET: {
                this.addTypeRecursive(((HollowCollectionSchema)schema).getElementType(), schemas);
            }
        }
    }

    public void addField(String type, String objectField) {
        ObjectFilterConfig typeConfig = this.specifiedFieldConfigs.get(type);
        if (typeConfig == null) {
            typeConfig = new ObjectFilterConfig();
            this.specifiedFieldConfigs.put(type, typeConfig);
        }
        typeConfig.addField(objectField);
    }

    public void addFieldRecursive(String type, String objectField, Collection<HollowSchema> schemas) {
        this.addFieldRecursive(type, objectField, this.mapSchemas(schemas));
    }

    public void addFieldRecursive(String type, String objectField, Map<String, HollowSchema> schemas) {
        this.addField(type, objectField);
        HollowObjectSchema schema = (HollowObjectSchema)schemas.get(type);
        if (schema.getFieldType(objectField) == HollowObjectSchema.FieldType.REFERENCE) {
            this.addTypeRecursive(schema.getReferencedType(objectField), schemas);
        }
    }

    public boolean doesIncludeType(String type) {
        if (this.isExcludeFilter) {
            return !this.specifiedTypes.contains(type);
        }
        return this.specifiedTypes.contains(type) || this.specifiedFieldConfigs.containsKey(type);
    }

    public boolean isExcludeFilter() {
        return this.isExcludeFilter;
    }

    public int numSpecifiedTypes() {
        return this.specifiedTypes.size();
    }

    public Set<String> getSpecifiedTypes() {
        return this.specifiedTypes;
    }

    public ObjectFilterConfig getObjectTypeConfig(String type) {
        ObjectFilterConfig typeConfig = this.specifiedFieldConfigs.get(type);
        if (typeConfig != null) {
            return typeConfig;
        }
        if (this.isExcludeFilter) {
            if (this.specifiedTypes.contains(type)) {
                return this.INCLUDE_NONE;
            }
            return this.INCLUDE_ALL;
        }
        if (this.specifiedTypes.contains(type)) {
            return this.INCLUDE_ALL;
        }
        return this.INCLUDE_NONE;
    }

    @Override
    public boolean includes(String type) {
        return this.doesIncludeType(type);
    }

    @Override
    public boolean includes(String type, String field) {
        return this.getObjectTypeConfig(type).includesField(field);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isExcludeFilter ? "EXCLUDE" : "INCLUDE");
        for (String string : this.specifiedTypes) {
            builder.append('\n').append(string);
        }
        for (Map.Entry entry : this.specifiedFieldConfigs.entrySet()) {
            String typeName = (String)entry.getKey();
            ObjectFilterConfig typeConfig = (ObjectFilterConfig)entry.getValue();
            if (typeConfig.specifiedFields.isEmpty()) {
                builder.append('\n').append(typeName);
                continue;
            }
            for (String field : typeConfig.specifiedFields) {
                builder.append('\n').append(typeName).append('.').append(field);
            }
        }
        return builder.toString();
    }

    public static HollowFilterConfig fromString(String conf) {
        String[] lines = conf.split("\n");
        HollowFilterConfig config = new HollowFilterConfig("EXCLUDE".equals(lines[0]));
        for (int i = 1; i < lines.length; ++i) {
            int delimiterIdx = lines[i].indexOf(46);
            if (delimiterIdx == -1) {
                config.addType(lines[i]);
                continue;
            }
            String type = lines[i].substring(0, delimiterIdx);
            String field = lines[i].substring(delimiterIdx + 1);
            config.addField(type, field);
        }
        return config;
    }

    private Map<String, HollowSchema> mapSchemas(Collection<HollowSchema> schemas) {
        HashMap<String, HollowSchema> schemaMap = new HashMap<String, HollowSchema>();
        for (HollowSchema schema : schemas) {
            schemaMap.put(schema.getName(), schema);
        }
        return schemaMap;
    }

    public class ObjectFilterConfig {
        private final Boolean alwaysAnswer;
        private final Set<String> specifiedFields = new HashSet<String>();

        public ObjectFilterConfig() {
            this(null);
        }

        public ObjectFilterConfig(Boolean alwaysAnswer) {
            this.alwaysAnswer = alwaysAnswer;
        }

        private void addField(String fieldName) {
            this.specifiedFields.add(fieldName);
        }

        public boolean includesField(String field) {
            if (this.alwaysAnswer != null) {
                return this.alwaysAnswer;
            }
            if (HollowFilterConfig.this.isExcludeFilter) {
                return !this.specifiedFields.contains(field);
            }
            return this.specifiedFields.contains(field);
        }

        public int numIncludedFields() {
            return this.specifiedFields.size();
        }
    }
}

