/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.set;

import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeDataElementsJoiner;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeDataElements;

class HollowSetTypeDataElementsJoiner
extends HollowTypeDataElementsJoiner<HollowSetTypeDataElements> {
    public HollowSetTypeDataElementsJoiner(HollowSetTypeDataElements[] from) {
        super((HollowTypeDataElements[])from);
    }

    @Override
    public void initToElements() {
        this.to = new HollowSetTypeDataElements(((HollowSetTypeDataElements[])this.from)[0].memoryMode, ((HollowSetTypeDataElements[])this.from)[0].memoryRecycler);
        ((HollowSetTypeDataElements)this.to).bitsPerElement = 0;
    }

    @Override
    public void populateStats() {
        for (int fromIndex = 0; fromIndex < ((HollowSetTypeDataElements[])this.from).length; ++fromIndex) {
            int mappedMaxOrdinal = ((HollowSetTypeDataElements[])this.from)[fromIndex].maxOrdinal == -1 ? -1 : ((HollowSetTypeDataElements[])this.from)[fromIndex].maxOrdinal * ((HollowSetTypeDataElements[])this.from).length + fromIndex;
            ((HollowSetTypeDataElements)this.to).maxOrdinal = Math.max(((HollowSetTypeDataElements)this.to).maxOrdinal, mappedMaxOrdinal);
            HollowSetTypeDataElements source = ((HollowSetTypeDataElements[])this.from)[fromIndex];
            if (source.bitsPerElement > ((HollowSetTypeDataElements)this.to).bitsPerElement) {
                ((HollowSetTypeDataElements)this.to).bitsPerElement = source.bitsPerElement;
            }
            if (source.bitsPerSetSizeValue <= ((HollowSetTypeDataElements)this.to).bitsPerSetSizeValue) continue;
            ((HollowSetTypeDataElements)this.to).bitsPerSetSizeValue = source.bitsPerSetSizeValue;
        }
        ((HollowSetTypeDataElements)this.to).emptyBucketValue = (1 << ((HollowSetTypeDataElements)this.to).bitsPerElement) - 1;
        long totalOfSetBuckets = 0L;
        for (int ordinal = 0; ordinal <= ((HollowSetTypeDataElements)this.to).maxOrdinal; ++ordinal) {
            int fromIndex = ordinal & this.fromMask;
            int fromOrdinal = ordinal >> this.fromOrdinalShift;
            HollowSetTypeDataElements source = ((HollowSetTypeDataElements[])this.from)[fromIndex];
            long startBucket = source.getStartBucket(fromOrdinal);
            long endBucket = source.getEndBucket(fromOrdinal);
            long numBuckets = endBucket - startBucket;
            totalOfSetBuckets += numBuckets;
        }
        ((HollowSetTypeDataElements)this.to).totalNumberOfBuckets = totalOfSetBuckets;
        ((HollowSetTypeDataElements)this.to).bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(((HollowSetTypeDataElements)this.to).totalNumberOfBuckets);
        ((HollowSetTypeDataElements)this.to).bitsPerFixedLengthSetPortion = ((HollowSetTypeDataElements)this.to).bitsPerSetPointer + ((HollowSetTypeDataElements)this.to).bitsPerSetSizeValue;
    }

    @Override
    public void copyRecords() {
        long bucketCounter = 0L;
        ((HollowSetTypeDataElements)this.to).setPointerAndSizeData = FixedLengthDataFactory.get(((long)((HollowSetTypeDataElements)this.to).maxOrdinal + 1L) * (long)((HollowSetTypeDataElements)this.to).bitsPerFixedLengthSetPortion, ((HollowSetTypeDataElements)this.to).memoryMode, ((HollowSetTypeDataElements)this.to).memoryRecycler);
        ((HollowSetTypeDataElements)this.to).elementData = FixedLengthDataFactory.get(((HollowSetTypeDataElements)this.to).totalNumberOfBuckets * (long)((HollowSetTypeDataElements)this.to).bitsPerElement, ((HollowSetTypeDataElements)this.to).memoryMode, ((HollowSetTypeDataElements)this.to).memoryRecycler);
        for (int ordinal = 0; ordinal <= ((HollowSetTypeDataElements)this.to).maxOrdinal; ++ordinal) {
            int fromIndex = ordinal & this.fromMask;
            int fromOrdinal = ordinal >> this.fromOrdinalShift;
            HollowSetTypeDataElements source = ((HollowSetTypeDataElements[])this.from)[fromIndex];
            long setSize = 0L;
            if (fromOrdinal <= ((HollowSetTypeDataElements[])this.from)[fromIndex].maxOrdinal) {
                long startBucket = source.getStartBucket(fromOrdinal);
                long endBucket = source.getEndBucket(fromOrdinal);
                long numBuckets = endBucket - startBucket;
                ((HollowSetTypeDataElements)this.to).copyBucketsFrom(bucketCounter, source, startBucket, endBucket);
                bucketCounter += numBuckets;
                setSize = source.setPointerAndSizeData.getElementValue((long)(fromOrdinal * source.bitsPerFixedLengthSetPortion) + (long)source.bitsPerSetPointer, source.bitsPerSetSizeValue);
            }
            ((HollowSetTypeDataElements)this.to).setPointerAndSizeData.setElementValue((long)ordinal * (long)((HollowSetTypeDataElements)this.to).bitsPerFixedLengthSetPortion, ((HollowSetTypeDataElements)this.to).bitsPerSetPointer, bucketCounter);
            ((HollowSetTypeDataElements)this.to).setPointerAndSizeData.setElementValue((long)(ordinal * ((HollowSetTypeDataElements)this.to).bitsPerFixedLengthSetPortion) + (long)((HollowSetTypeDataElements)this.to).bitsPerSetPointer, ((HollowSetTypeDataElements)this.to).bitsPerSetSizeValue, setSize);
        }
    }
}

