/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.map;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowMapSampler;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.index.key.HollowPrimaryKeyValueDeriver;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.HollowTypeReadStateShard;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.SetMapKeyHasher;
import com.netflix.hollow.core.read.engine.ShardsHolder;
import com.netflix.hollow.core.read.engine.SnapshotPopulatedOrdinalsReader;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeDataElements;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadStateShard;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeShardsHolder;
import com.netflix.hollow.core.read.engine.map.PotentialMatchHollowMapEntryOrdinalIteratorImpl;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.read.iterator.EmptyMapOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIteratorImpl;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.tools.checksum.HollowChecksum;
import java.io.IOException;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HollowMapTypeReadState
extends HollowTypeReadState
implements HollowMapTypeDataAccess {
    private static final Logger LOG = Logger.getLogger(HollowMapTypeReadState.class.getName());
    private final HollowMapSampler sampler;
    private int maxOrdinal;
    private volatile HollowPrimaryKeyValueDeriver keyDeriver;
    volatile HollowMapTypeShardsHolder shardsVolatile;

    @Override
    public ShardsHolder getShardsVolatile() {
        return this.shardsVolatile;
    }

    @Override
    public void updateShardsVolatile(HollowTypeReadStateShard[] shards) {
        this.shardsVolatile = new HollowMapTypeShardsHolder(shards);
    }

    @Override
    public HollowTypeDataElements[] createTypeDataElements(int len) {
        return new HollowMapTypeDataElements[len];
    }

    @Override
    public HollowTypeReadStateShard createTypeReadStateShard(HollowSchema schema, HollowTypeDataElements dataElements, int shardOrdinalShift) {
        return new HollowMapTypeReadStateShard((HollowMapTypeDataElements)dataElements, shardOrdinalShift);
    }

    public HollowMapTypeReadState(HollowReadStateEngine stateEngine, MemoryMode memoryMode, HollowMapSchema schema) {
        super(stateEngine, memoryMode, schema);
        this.sampler = new HollowMapSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        this.shardsVolatile = null;
    }

    public HollowMapTypeReadState(HollowMapSchema schema, HollowMapTypeDataElements dataElements) {
        super(null, MemoryMode.ON_HEAP, schema);
        this.sampler = new HollowMapSampler(schema.getName(), DisabledSamplingDirector.INSTANCE);
        HollowMapTypeReadStateShard newShard = new HollowMapTypeReadStateShard(dataElements, 0);
        this.shardsVolatile = new HollowMapTypeShardsHolder(new HollowMapTypeReadStateShard[]{newShard});
        this.maxOrdinal = dataElements.maxOrdinal;
    }

    @Override
    public void readSnapshot(HollowBlobInput in, ArraySegmentRecycler memoryRecycler, int numShards) throws IOException {
        if (numShards > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        HollowTypeReadStateShard[] newShards = new HollowMapTypeReadStateShard[numShards];
        int shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(numShards);
        for (int i = 0; i < numShards; ++i) {
            HollowMapTypeDataElements shardDataElements = new HollowMapTypeDataElements(this.memoryMode, memoryRecycler);
            shardDataElements.readSnapshot(in);
            newShards[i] = new HollowMapTypeReadStateShard(shardDataElements, shardOrdinalShift);
        }
        this.shardsVolatile = new HollowMapTypeShardsHolder(newShards);
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
        SnapshotPopulatedOrdinalsReader.readOrdinals(in, this.stateListeners);
    }

    @Override
    public void applyDelta(HollowBlobInput in, HollowSchema schema, ArraySegmentRecycler memoryRecycler, int deltaNumShards) throws IOException {
        if (this.shardsVolatile.shards.length > 1) {
            this.maxOrdinal = VarInt.readVInt(in);
        }
        for (int i = 0; i < this.shardsVolatile.shards.length; ++i) {
            HollowMapTypeDataElements deltaData = new HollowMapTypeDataElements(this.memoryMode, memoryRecycler);
            deltaData.readDelta(in);
            if (this.stateEngine.isSkipTypeShardUpdateWithNoAdditions() && deltaData.encodedAdditions.isEmpty()) {
                GapEncodedVariableLengthIntegerReader oldRemovals;
                if (!deltaData.encodedRemovals.isEmpty()) {
                    this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                }
                HollowMapTypeDataElements currentData = this.shardsVolatile.shards[i].dataElements;
                GapEncodedVariableLengthIntegerReader gapEncodedVariableLengthIntegerReader = oldRemovals = currentData.encodedRemovals == null ? GapEncodedVariableLengthIntegerReader.EMPTY_READER : currentData.encodedRemovals;
                if (oldRemovals.isEmpty()) {
                    currentData.encodedRemovals = deltaData.encodedRemovals;
                    oldRemovals.destroy();
                } else {
                    if (!deltaData.encodedRemovals.isEmpty()) {
                        currentData.encodedRemovals = GapEncodedVariableLengthIntegerReader.combine(oldRemovals, deltaData.encodedRemovals, memoryRecycler);
                        oldRemovals.destroy();
                    }
                    deltaData.encodedRemovals.destroy();
                }
                deltaData.encodedAdditions.destroy();
            } else {
                HollowMapTypeDataElements nextData = new HollowMapTypeDataElements(this.memoryMode, memoryRecycler);
                HollowMapTypeDataElements oldData = this.shardsVolatile.shards[i].dataElements;
                nextData.applyDelta(oldData, deltaData);
                HollowMapTypeReadStateShard newShard = new HollowMapTypeReadStateShard(nextData, this.shardsVolatile.shards[i].shardOrdinalShift);
                this.shardsVolatile = new HollowMapTypeShardsHolder(this.shardsVolatile.shards, newShard, i);
                this.notifyListenerAboutDeltaChanges(deltaData.encodedRemovals, deltaData.encodedAdditions, i, this.shardsVolatile.shards.length);
                deltaData.encodedAdditions.destroy();
                oldData.destroy();
            }
            deltaData.destroy();
            this.stateEngine.getMemoryRecycler().swap();
        }
        if (this.shardsVolatile.shards.length == 1) {
            this.maxOrdinal = this.shardsVolatile.shards[0].dataElements.maxOrdinal;
        }
    }

    public static void discardSnapshot(HollowBlobInput in, int numShards) throws IOException {
        HollowMapTypeReadState.discardType(in, numShards, false);
    }

    public static void discardDelta(HollowBlobInput in, int numShards) throws IOException {
        HollowMapTypeReadState.discardType(in, numShards, true);
    }

    public static void discardType(HollowBlobInput in, int numShards, boolean delta) throws IOException {
        HollowMapTypeDataElements.discardFromInput(in, numShards, delta);
        if (!delta) {
            SnapshotPopulatedOrdinalsReader.discardOrdinals(in);
        }
    }

    @Override
    public int maxOrdinal() {
        return this.maxOrdinal;
    }

    @Override
    public int size(int ordinal) {
        int size;
        HollowMapTypeReadStateShard shard;
        HollowMapTypeShardsHolder shardsHolder;
        this.sampler.recordSize();
        do {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            size = shard.size(ordinal >> shard.shardOrdinalShift);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return size;
    }

    @Override
    public int get(int ordinal, int keyOrdinal) {
        return this.get(ordinal, keyOrdinal, keyOrdinal);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int get(int ordinal, int keyOrdinal, int hashCode) {
        this.sampler.recordGet();
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            startBucket = shard.dataElements.getStartBucket(shardOrdinal);
            endBucket = shard.dataElements.getEndBucket(shardOrdinal);
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            valueOrdinal = shard.get(hashCode, startBucket, endBucket, keyOrdinal);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return valueOrdinal;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int findKey(int ordinal, Object ... hashKey) {
        this.sampler.recordGet();
        if (this.keyDeriver == null) {
            return -1;
        }
        fieldTypes = this.keyDeriver.getFieldTypes();
        if (hashKey.length != fieldTypes.length) {
            return -1;
        }
        hashCode = SetMapKeyHasher.hash(hashKey, this.keyDeriver.getFieldTypes());
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            startBucket = shard.dataElements.getStartBucket(shardOrdinal);
            endBucket = shard.dataElements.getEndBucket(shardOrdinal);
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketKeyOrdinal = shard.dataElements.getBucketKeyByAbsoluteIndex(bucket);
            while (bucketKeyOrdinal != shard.dataElements.emptyBucketKeyValue && !this.readWasUnsafe(shardsHolder, ordinal, shard)) {
                if (this.keyDeriver.keyMatches(bucketKeyOrdinal, hashKey)) {
                    return bucketKeyOrdinal;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketKeyOrdinal = shard.dataElements.getBucketKeyByAbsoluteIndex(bucket);
            }
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return -1;
    }

    @Override
    public int findValue(int ordinal, Object ... hashKey) {
        return (int)this.findEntry(ordinal, hashKey);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long findEntry(int ordinal, Object ... hashKey) {
        this.sampler.recordGet();
        if (this.keyDeriver == null) {
            return -1L;
        }
        fieldTypes = this.keyDeriver.getFieldTypes();
        if (hashKey.length != fieldTypes.length) {
            return -1L;
        }
        hashCode = SetMapKeyHasher.hash(hashKey, this.keyDeriver.getFieldTypes());
        block0: do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            shardOrdinal = ordinal >> shard.shardOrdinalShift;
            startBucket = shard.dataElements.getStartBucket(shardOrdinal);
            endBucket = shard.dataElements.getEndBucket(shardOrdinal);
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            bucket = startBucket + ((long)hashCode & endBucket - startBucket - 1L);
            bucketKeyOrdinal = shard.dataElements.getBucketKeyByAbsoluteIndex(bucket);
            while (bucketKeyOrdinal != shard.dataElements.emptyBucketKeyValue && !this.readWasUnsafe(shardsHolder, ordinal, shard)) {
                if (this.keyDeriver.keyMatches(bucketKeyOrdinal, hashKey)) {
                    valueOrdinal = shard.dataElements.getBucketValueByAbsoluteIndex(bucket);
                    if (this.readWasUnsafe(shardsHolder, ordinal, shard)) continue block0;
                    return (long)bucketKeyOrdinal << 32 | valueOrdinal;
                }
                if (++bucket == endBucket) {
                    bucket = startBucket;
                }
                bucketKeyOrdinal = shard.dataElements.getBucketKeyByAbsoluteIndex(bucket);
            }
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return -1L;
    }

    @Override
    public HollowMapEntryOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        this.sampler.recordGet();
        if (this.size(ordinal) == 0) {
            return EmptyMapOrdinalIterator.INSTANCE;
        }
        return new PotentialMatchHollowMapEntryOrdinalIteratorImpl(ordinal, this, hashCode);
    }

    @Override
    public HollowMapEntryOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler.recordIterator();
        if (this.size(ordinal) == 0) {
            return EmptyMapOrdinalIterator.INSTANCE;
        }
        return new HollowMapEntryOrdinalIteratorImpl(ordinal, this);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long relativeBucket(int ordinal, int bucketIndex) {
        do lbl-1000:
        // 3 sources

        {
            shardsHolder = this.shardsVolatile;
            shard = shardsHolder.shards[ordinal & shardsHolder.shardNumberMask];
            absoluteBucketIndex = shard.dataElements.getStartBucket(ordinal >> shard.shardOrdinalShift) + (long)bucketIndex;
            if (this.readWasUnsafe(shardsHolder, ordinal, shard)) ** GOTO lbl-1000
            bucketValue = shard.relativeBucket(absoluteBucketIndex);
        } while (this.readWasUnsafe(shardsHolder, ordinal, shard));
        return bucketValue;
    }

    private boolean readWasUnsafe(HollowMapTypeShardsHolder shardsHolder, int ordinal, HollowMapTypeReadStateShard shard) {
        HollowUnsafeHandle.getUnsafe().loadFence();
        HollowMapTypeShardsHolder currShardsHolder = this.shardsVolatile;
        return shardsHolder != currShardsHolder && shard != currShardsHolder.shards[ordinal & currShardsHolder.shardNumberMask];
    }

    @Override
    public HollowMapSchema getSchema() {
        return (HollowMapSchema)this.schema;
    }

    @Override
    public HollowSampler getSampler() {
        return this.sampler;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        this.sampler.setSamplingDirector(director);
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        this.sampler.setFieldSpecificSamplingDirector(fieldSpec, director);
    }

    @Override
    public void ignoreUpdateThreadForSampling(Thread t) {
        this.sampler.setUpdateThread(t);
    }

    @Override
    protected void invalidate() {
        this.stateListeners = EMPTY_LISTENERS;
        HollowMapTypeReadStateShard[] shards = this.shardsVolatile.shards;
        int numShards = shards.length;
        HollowTypeReadStateShard[] newShards = new HollowMapTypeReadStateShard[numShards];
        for (int i = 0; i < numShards; ++i) {
            newShards[i] = new HollowMapTypeReadStateShard(null, shards[i].shardOrdinalShift);
        }
        this.shardsVolatile = new HollowMapTypeShardsHolder(newShards);
    }

    HollowMapTypeDataElements[] currentDataElements() {
        HollowMapTypeReadStateShard[] shards = this.shardsVolatile.shards;
        HollowMapTypeDataElements[] elements = new HollowMapTypeDataElements[shards.length];
        for (int i = 0; i < shards.length; ++i) {
            elements[i] = shards[i].dataElements;
        }
        return elements;
    }

    @Override
    protected void applyToChecksum(HollowChecksum checksum, HollowSchema withSchema) {
        HollowMapTypeReadStateShard[] shards = this.shardsVolatile.shards;
        if (!this.getSchema().equals(withSchema)) {
            throw new IllegalArgumentException("HollowMapTypeReadState cannot calculate checksum with unequal schemas: " + this.getSchema().getName());
        }
        BitSet populatedOrdinals = this.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            shards[i].applyShardToChecksum(checksum, populatedOrdinals, i, shards.length);
        }
    }

    @Override
    public long getApproximateHeapFootprintInBytes() {
        HollowMapTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHeapFootprintInBytes = 0L;
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHeapFootprintInBytes += shards[i].getApproximateHeapFootprintInBytes();
        }
        return totalApproximateHeapFootprintInBytes;
    }

    @Override
    public long getApproximateHoleCostInBytes() {
        HollowMapTypeReadStateShard[] shards = this.shardsVolatile.shards;
        long totalApproximateHoleCostInBytes = 0L;
        BitSet populatedOrdinals = this.getPopulatedOrdinals();
        for (int i = 0; i < shards.length; ++i) {
            totalApproximateHoleCostInBytes += shards[i].getApproximateHoleCostInBytes(populatedOrdinals, i, shards.length);
        }
        return totalApproximateHoleCostInBytes;
    }

    public HollowPrimaryKeyValueDeriver getKeyDeriver() {
        return this.keyDeriver;
    }

    public void buildKeyDeriver() {
        if (this.getSchema().getHashKey() != null) {
            try {
                this.keyDeriver = new HollowPrimaryKeyValueDeriver(this.getSchema().getHashKey(), this.getStateEngine());
            }
            catch (FieldPaths.FieldPathException e) {
                if (e.error == FieldPaths.FieldPathException.ErrorKind.NOT_BINDABLE) {
                    LOG.log(Level.WARNING, "Failed to create a key value deriver for " + this.getSchema().getHashKey() + " because a field could not be bound to a type in the state");
                }
                throw e;
            }
        }
    }

    @Override
    public int numShards() {
        return this.shardsVolatile.shards.length;
    }
}

