/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.FixedLengthData;
import com.netflix.hollow.core.memory.FixedLengthDataFactory;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.GapEncodedVariableLengthIntegerReader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.ArraySegmentRecycler;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowTypeDataElements;
import com.netflix.hollow.core.read.engine.list.HollowListDeltaApplicator;
import java.io.IOException;

public class HollowListTypeDataElements
extends HollowTypeDataElements {
    FixedLengthData listPointerData;
    FixedLengthData elementData;
    int bitsPerListPointer;
    int bitsPerElement;
    long totalNumberOfElements;

    public HollowListTypeDataElements(ArraySegmentRecycler memoryRecycler) {
        this(MemoryMode.ON_HEAP, memoryRecycler);
    }

    public HollowListTypeDataElements(MemoryMode memoryMode, ArraySegmentRecycler memoryRecycler) {
        super(memoryMode, memoryRecycler);
    }

    void readSnapshot(HollowBlobInput in) throws IOException {
        this.readFromInput(in, false);
    }

    void readDelta(HollowBlobInput in) throws IOException {
        this.readFromInput(in, true);
    }

    private void readFromInput(HollowBlobInput in, boolean isDelta) throws IOException {
        this.maxOrdinal = VarInt.readVInt(in);
        if (isDelta) {
            this.encodedRemovals = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
            this.encodedAdditions = GapEncodedVariableLengthIntegerReader.readEncodedDeltaOrdinals(in, this.memoryRecycler);
        }
        this.bitsPerListPointer = VarInt.readVInt(in);
        this.bitsPerElement = VarInt.readVInt(in);
        this.totalNumberOfElements = VarInt.readVLong(in);
        this.listPointerData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
        this.elementData = FixedLengthDataFactory.get(in, this.memoryMode, this.memoryRecycler);
    }

    static void discardFromStream(HollowBlobInput in, int numShards, boolean isDelta) throws IOException {
        if (numShards > 1) {
            VarInt.readVInt(in);
        }
        for (int i = 0; i < numShards; ++i) {
            VarInt.readVInt(in);
            if (isDelta) {
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
                GapEncodedVariableLengthIntegerReader.discardEncodedDeltaOrdinals(in);
            }
            VarInt.readVInt(in);
            VarInt.readVInt(in);
            VarInt.readVLong(in);
            FixedLengthData.discardFrom(in);
            FixedLengthData.discardFrom(in);
        }
    }

    public void applyDelta(HollowListTypeDataElements fromData, HollowListTypeDataElements deltaData) {
        new HollowListDeltaApplicator(fromData, deltaData, this).applyDelta();
    }

    @Override
    public void destroy() {
        FixedLengthDataFactory.destroy(this.listPointerData, this.memoryRecycler);
        FixedLengthDataFactory.destroy(this.elementData, this.memoryRecycler);
    }

    long getStartElement(int ordinal) {
        return ordinal == 0 ? 0L : this.listPointerData.getElementValue((long)(ordinal - 1) * (long)this.bitsPerListPointer, this.bitsPerListPointer);
    }

    long getEndElement(int ordinal) {
        return this.listPointerData.getElementValue((long)ordinal * (long)this.bitsPerListPointer, this.bitsPerListPointer);
    }

    void copyElementsFrom(long startElement, HollowListTypeDataElements src, long srcStartElement, long srcEndElement) {
        if (this.bitsPerElement == src.bitsPerElement) {
            long numElements = srcEndElement - srcStartElement;
            this.elementData.copyBits(src.elementData, srcStartElement * (long)this.bitsPerElement, startElement * (long)this.bitsPerElement, numElements * (long)this.bitsPerElement);
        } else {
            for (long element = srcStartElement; element < srcEndElement; ++element) {
                long elementVal = src.elementData.getElementValue(element * (long)src.bitsPerElement, src.bitsPerElement);
                this.elementData.setElementValue(startElement * (long)this.bitsPerElement, this.bitsPerElement, elementVal);
                ++startElement;
            }
        }
    }
}

