/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.engine.list;

import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.list.HollowListTypeDataElements;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;

public class HollowListDeltaHistoricalStateCreator {
    private final HollowListTypeDataElements historicalDataElements;
    private final int shardNumberMask;
    private final int shardOrdinalShift;
    private HollowListTypeReadState typeState;
    private HollowListTypeDataElements[] stateEngineDataElements;
    private RemovedOrdinalIterator iter;
    private IntMap ordinalMapping;
    private int nextOrdinal = 0;
    private long nextStartElement = 0L;

    public HollowListDeltaHistoricalStateCreator(HollowListTypeReadState typeState, boolean reverse) {
        this.typeState = typeState;
        this.stateEngineDataElements = typeState.currentDataElements();
        this.historicalDataElements = new HollowListTypeDataElements(WastefulRecycler.DEFAULT_INSTANCE);
        this.iter = new RemovedOrdinalIterator(typeState.getListener(PopulatedOrdinalListener.class), reverse);
        this.shardNumberMask = this.stateEngineDataElements.length - 1;
        this.shardOrdinalShift = 31 - Integer.numberOfLeadingZeros(this.stateEngineDataElements.length);
    }

    public void populateHistory() {
        this.populateStats();
        this.historicalDataElements.listPointerData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, ((long)this.historicalDataElements.maxOrdinal + 1L) * (long)this.historicalDataElements.bitsPerListPointer);
        this.historicalDataElements.elementData = new FixedLengthElementArray(this.historicalDataElements.memoryRecycler, this.historicalDataElements.totalNumberOfElements * (long)this.historicalDataElements.bitsPerElement);
        this.iter.reset();
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            this.ordinalMapping.put(ordinal, this.nextOrdinal);
            this.copyRecord(ordinal);
            ordinal = this.iter.next();
        }
    }

    public void dereferenceTypeState() {
        this.typeState = null;
        this.stateEngineDataElements = null;
        this.iter = null;
    }

    public IntMap getOrdinalMapping() {
        return this.ordinalMapping;
    }

    public HollowListTypeReadState createHistoricalTypeReadState() {
        HollowListTypeReadState historicalTypeState = new HollowListTypeReadState(this.typeState.getSchema(), this.historicalDataElements);
        return historicalTypeState;
    }

    private void populateStats() {
        this.iter.reset();
        int removedEntryCount = 0;
        long totalElementCount = 0L;
        int ordinal = this.iter.next();
        while (ordinal != -1) {
            ++removedEntryCount;
            totalElementCount += (long)this.typeState.size(ordinal);
            ordinal = this.iter.next();
        }
        this.historicalDataElements.maxOrdinal = removedEntryCount - 1;
        this.historicalDataElements.totalNumberOfElements = totalElementCount;
        this.historicalDataElements.bitsPerListPointer = totalElementCount == 0L ? 1 : 64 - Long.numberOfLeadingZeros(totalElementCount);
        for (int i = 0; i < this.stateEngineDataElements.length; ++i) {
            if (this.stateEngineDataElements[i].bitsPerElement <= this.historicalDataElements.bitsPerElement) continue;
            this.historicalDataElements.bitsPerElement = this.stateEngineDataElements[i].bitsPerElement;
        }
        this.ordinalMapping = new IntMap(removedEntryCount);
    }

    private void copyRecord(int ordinal) {
        int shard = ordinal & this.shardNumberMask;
        int shardOrdinal = ordinal >> this.shardOrdinalShift;
        long bitsPerElement = this.stateEngineDataElements[shard].bitsPerElement;
        long fromStartElement = this.stateEngineDataElements[shard].getStartElement(shardOrdinal);
        long fromEndElement = this.stateEngineDataElements[shard].getEndElement(shardOrdinal);
        long size = fromEndElement - fromStartElement;
        this.historicalDataElements.elementData.copyBits(this.stateEngineDataElements[shard].elementData, fromStartElement * bitsPerElement, this.nextStartElement * bitsPerElement, size * bitsPerElement);
        this.historicalDataElements.listPointerData.setElementValue((long)this.nextOrdinal * (long)this.historicalDataElements.bitsPerListPointer, this.historicalDataElements.bitsPerListPointer, this.nextStartElement + size);
        this.ordinalMapping.put(ordinal, this.nextOrdinal);
        ++this.nextOrdinal;
        this.nextStartElement += size;
    }
}

