/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.memory.encoding.BlobByteBuffer;
import com.netflix.hollow.core.read.OptionalBlobPartInput;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class HollowBlobInput
implements Closeable {
    private final MemoryMode memoryMode;
    private Object input;
    private BlobByteBuffer buffer;

    private HollowBlobInput(MemoryMode memoryMode) {
        this.memoryMode = memoryMode;
    }

    public MemoryMode getMemoryMode() {
        return this.memoryMode;
    }

    public static HollowBlobInput modeBasedSelector(MemoryMode mode, HollowConsumer.Blob blob) throws IOException {
        if (mode.equals((Object)MemoryMode.ON_HEAP)) {
            return HollowBlobInput.serial(blob.getInputStream());
        }
        if (mode.equals((Object)MemoryMode.SHARED_MEMORY_LAZY)) {
            return HollowBlobInput.randomAccess(blob.getFile());
        }
        throw new UnsupportedOperationException();
    }

    public static HollowBlobInput modeBasedSelector(MemoryMode mode, OptionalBlobPartInput input, String partName) throws IOException {
        if (mode.equals((Object)MemoryMode.ON_HEAP)) {
            return HollowBlobInput.serial(input.getInputStream(partName));
        }
        if (mode.equals((Object)MemoryMode.SHARED_MEMORY_LAZY)) {
            return HollowBlobInput.randomAccess(input.getFile(partName));
        }
        throw new UnsupportedOperationException();
    }

    public static HollowBlobInput randomAccess(File f) throws IOException {
        return HollowBlobInput.randomAccess(f, 0x40000000);
    }

    public static HollowBlobInput randomAccess(File f, int singleBufferCapacity) throws IOException {
        HollowBlobInput hbi = new HollowBlobInput(MemoryMode.SHARED_MEMORY_LAZY);
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        hbi.input = raf;
        FileChannel channel = ((RandomAccessFile)hbi.input).getChannel();
        hbi.buffer = BlobByteBuffer.mmapBlob(channel, singleBufferCapacity);
        return hbi;
    }

    public static HollowBlobInput serial(byte[] bytes) {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        return HollowBlobInput.serial(is);
    }

    public static HollowBlobInput serial(InputStream is) {
        HollowBlobInput hbi = new HollowBlobInput(MemoryMode.ON_HEAP);
        hbi.input = new DataInputStream(is);
        return hbi;
    }

    public int read() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).read();
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).read();
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).read(b, off, len);
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).read(b, off, len);
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public void seek(long pos) throws IOException {
        if (!(this.input instanceof RandomAccessFile)) {
            if (this.input instanceof DataInputStream) {
                throw new UnsupportedOperationException("Can not seek on Hollow Blob Input of type DataInputStream");
            }
            throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
        }
        ((RandomAccessFile)this.input).seek(pos);
    }

    public long getFilePointer() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).getFilePointer();
        }
        if (this.input instanceof DataInputStream) {
            throw new UnsupportedOperationException("Can not get file pointer for Hollow Blob Input of type DataInputStream");
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public final short readShort() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).readShort();
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).readShort();
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public final int readInt() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).readInt();
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).readInt();
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public final long readLong() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).readLong();
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).readLong();
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public final String readUTF() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.input).readUTF();
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).readUTF();
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    public long skipBytes(long n) throws IOException {
        if (this.input instanceof RandomAccessFile) {
            long total = 0L;
            int expected = 0;
            int actual = 0;
            while ((total += (long)(actual = ((RandomAccessFile)this.input).skipBytes(expected = n - total > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)(n - total)))) < n && actual > 0) {
            }
            return total;
        }
        if (this.input instanceof DataInputStream) {
            return ((DataInputStream)this.input).skip(n);
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }

    @Override
    public void close() throws IOException {
        if (this.input instanceof RandomAccessFile) {
            ((RandomAccessFile)this.input).close();
        } else if (this.input instanceof DataInputStream) {
            ((DataInputStream)this.input).close();
        } else {
            throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
        }
    }

    public Object getInput() {
        return this.input;
    }

    public BlobByteBuffer getBuffer() {
        if (this.input instanceof RandomAccessFile) {
            return this.buffer;
        }
        if (this.input instanceof DataInputStream) {
            throw new UnsupportedOperationException("No buffer associated with underlying DataInputStream");
        }
        throw new UnsupportedOperationException("Unknown Hollow Blob Input type");
    }
}

