/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index.traversal;

import com.netflix.hollow.core.index.traversal.HollowIndexerTraversalNode;
import com.netflix.hollow.core.index.traversal.TraversalTreeBuilder;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.util.IntList;
import java.util.BitSet;

public class HollowIndexerValueTraverser {
    private final String[] fieldPaths;
    private final HollowIndexerTraversalNode rootNode;
    private final IntList[] fieldMatchLists;
    private final HollowTypeDataAccess[] fieldTypeDataAccess;
    private final int[] fieldSchemaPosition;

    public HollowIndexerValueTraverser(HollowDataAccess dataAccess, String type, String ... fieldPaths) {
        this.fieldPaths = fieldPaths;
        TraversalTreeBuilder builder = new TraversalTreeBuilder(dataAccess, type, fieldPaths);
        this.rootNode = builder.buildTree();
        this.fieldMatchLists = builder.getFieldMatchLists();
        this.fieldTypeDataAccess = builder.getFieldTypeDataAccesses();
        this.fieldSchemaPosition = builder.getFieldSchemaPositions();
    }

    public void traverse(int ordinal) {
        for (int i = 0; i < this.fieldMatchLists.length; ++i) {
            this.fieldMatchLists[i].clear();
        }
        this.rootNode.traverse(ordinal);
    }

    public int getNumFieldPaths() {
        return this.fieldPaths.length;
    }

    public String getFieldPath(int idx) {
        return this.fieldPaths[idx];
    }

    public int getNumMatches() {
        return this.fieldMatchLists[0].size();
    }

    public Object getMatchedValue(int matchIdx, int fieldIdx) {
        int matchedOrdinal = this.fieldMatchLists[fieldIdx].get(matchIdx);
        return HollowReadFieldUtils.fieldValueObject((HollowObjectTypeDataAccess)this.fieldTypeDataAccess[fieldIdx], matchedOrdinal, this.fieldSchemaPosition[fieldIdx]);
    }

    public boolean isMatchedValueEqual(int matchIdx, int fieldIdx, Object value) {
        int matchedOrdinal = this.fieldMatchLists[fieldIdx].get(matchIdx);
        return HollowReadFieldUtils.fieldValueEquals((HollowObjectTypeDataAccess)this.fieldTypeDataAccess[fieldIdx], matchedOrdinal, this.fieldSchemaPosition[fieldIdx], value);
    }

    public int getMatchHash(int matchIdx) {
        int hashCode = 0;
        for (int i = 0; i < this.getNumFieldPaths(); ++i) {
            hashCode ^= HashCodes.hashInt(HollowReadFieldUtils.fieldHashCode((HollowObjectTypeDataAccess)this.fieldTypeDataAccess[i], this.fieldMatchLists[i].get(matchIdx), this.fieldSchemaPosition[i]));
            hashCode ^= HashCodes.hashInt(hashCode);
        }
        return hashCode;
    }

    public int getMatchHash(int matchIdx, BitSet fields) {
        int hashCode = 0;
        for (int i = 0; i < this.getNumFieldPaths(); ++i) {
            if (!fields.get(i)) continue;
            hashCode ^= HashCodes.hashInt(HollowReadFieldUtils.fieldHashCode((HollowObjectTypeDataAccess)this.fieldTypeDataAccess[i], this.fieldMatchLists[i].get(matchIdx), this.fieldSchemaPosition[i]));
            hashCode ^= HashCodes.hashInt(hashCode);
        }
        return hashCode;
    }

    public boolean isMatchEqual(int matchIdx, HollowIndexerValueTraverser otherTraverser, int otherMatchIdx) {
        for (int i = 0; i < this.getNumFieldPaths(); ++i) {
            if (HollowReadFieldUtils.fieldsAreEqual((HollowObjectTypeDataAccess)this.fieldTypeDataAccess[i], this.fieldMatchLists[i].get(matchIdx), this.fieldSchemaPosition[i], (HollowObjectTypeDataAccess)otherTraverser.fieldTypeDataAccess[i], otherTraverser.fieldMatchLists[i].get(otherMatchIdx), otherTraverser.fieldSchemaPosition[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isMatchEqual(int matchIdx, HollowIndexerValueTraverser otherTraverser, int otherMatchIdx, BitSet fields) {
        for (int i = 0; i < this.getNumFieldPaths(); ++i) {
            if (!fields.get(i) || HollowReadFieldUtils.fieldsAreEqual((HollowObjectTypeDataAccess)this.fieldTypeDataAccess[i], this.fieldMatchLists[i].get(matchIdx), this.fieldSchemaPosition[i], (HollowObjectTypeDataAccess)otherTraverser.fieldTypeDataAccess[i], otherTraverser.fieldMatchLists[i].get(otherMatchIdx), otherTraverser.fieldSchemaPosition[i])) continue;
            return false;
        }
        return true;
    }

    public int getMatchOrdinal(int matchIdx, int fieldIdx) {
        return this.fieldMatchLists[fieldIdx].get(matchIdx);
    }

    public HollowTypeDataAccess getFieldTypeDataAccess(int fieldIdx) {
        return this.fieldTypeDataAccess[fieldIdx];
    }
}

