/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public class HollowHashIndexField {
    private final int baseIteratorFieldIdx;
    private final FieldPathSegment[] schemaFieldPositionPath;
    private final HollowTypeDataAccess baseDataAccess;
    private final HollowObjectSchema.FieldType fieldType;

    public HollowHashIndexField(int baseIteratorFieldIdx, FieldPathSegment[] remainingPath, HollowTypeDataAccess baseDataAccess, HollowObjectSchema.FieldType fieldType) {
        this.baseIteratorFieldIdx = baseIteratorFieldIdx;
        this.schemaFieldPositionPath = remainingPath;
        this.baseDataAccess = baseDataAccess;
        this.fieldType = fieldType;
    }

    public HollowTypeDataAccess getBaseDataAccess() {
        return this.baseDataAccess;
    }

    public int getBaseIteratorFieldIdx() {
        return this.baseIteratorFieldIdx;
    }

    public FieldPathSegment[] getSchemaFieldPositionPath() {
        return this.schemaFieldPositionPath;
    }

    FieldPathSegment getLastFieldPositionPathElement() {
        return this.schemaFieldPositionPath[this.schemaFieldPositionPath.length - 1];
    }

    public HollowObjectSchema.FieldType getFieldType() {
        return this.fieldType;
    }

    static class FieldPathSegment {
        private final int fieldPosition;
        private final HollowObjectTypeDataAccess objectTypeDataAccess;

        FieldPathSegment(int fieldPosition, HollowObjectTypeDataAccess objectTypeDataAccess) {
            this.fieldPosition = fieldPosition;
            this.objectTypeDataAccess = objectTypeDataAccess;
        }

        int getOrdinalForField(int ordinal) {
            return this.objectTypeDataAccess.readOrdinal(ordinal, this.fieldPosition);
        }

        int getSegmentFieldPosition() {
            return this.fieldPosition;
        }

        HollowObjectTypeDataAccess getObjectTypeDataAccess() {
            return this.objectTypeDataAccess;
        }
    }
}

