/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.index;

import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.read.dataaccess.HollowCollectionTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowCollectionSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.ArrayList;

class FieldPath {
    private final String fieldPath;
    private final HollowDataAccess hollowDataAccess;
    private final String type;
    private String[] fields;
    private int[] fieldPositions;
    private HollowObjectSchema.FieldType[] fieldTypes;
    private String lastRefTypeInPath;
    private boolean autoExpand;

    FieldPath(HollowDataAccess hollowDataAccess, String type, String fieldPath) {
        this(hollowDataAccess, type, fieldPath, true);
    }

    FieldPath(HollowDataAccess hollowDataAccess, String type, String fieldPath, boolean autoExpand) {
        this.fieldPath = fieldPath;
        this.hollowDataAccess = hollowDataAccess;
        this.type = type;
        this.autoExpand = autoExpand;
        this.initialize();
    }

    private void initialize() {
        FieldPaths.FieldPath<FieldPaths.FieldSegment> path = FieldPaths.createFieldPathForPrefixIndex(this.hollowDataAccess, this.type, this.fieldPath, this.autoExpand);
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Integer> fieldPositions = new ArrayList<Integer>();
        ArrayList<HollowObjectSchema.FieldType> fieldTypes = new ArrayList<HollowObjectSchema.FieldType>();
        String lastRefType = this.type;
        for (FieldPaths.FieldSegment segment : path.getSegments()) {
            String refType;
            fields.add(segment.getName());
            if (segment.getEnclosingSchema().getSchemaType() == HollowSchema.SchemaType.OBJECT) {
                assert (segment instanceof FieldPaths.ObjectFieldSegment);
                FieldPaths.ObjectFieldSegment oSegment = (FieldPaths.ObjectFieldSegment)segment;
                fieldPositions.add(oSegment.getIndex());
                fieldTypes.add(oSegment.getType());
            } else {
                fieldPositions.add(0);
                fieldTypes.add(HollowObjectSchema.FieldType.REFERENCE);
            }
            if ((refType = segment.getTypeName()) == null) continue;
            lastRefType = refType;
        }
        this.fields = fields.toArray(new String[0]);
        this.fieldPositions = fieldPositions.stream().mapToInt(i -> i).toArray();
        this.fieldTypes = fieldTypes.toArray(new HollowObjectSchema.FieldType[0]);
        this.lastRefTypeInPath = lastRefType;
    }

    String getLastRefTypeInPath() {
        return this.lastRefTypeInPath;
    }

    HollowObjectSchema.FieldType getLastFieldType() {
        return this.fieldTypes[this.fields.length - 1];
    }

    Object[] findValues(int ordinal) {
        return this.getAllValues(ordinal, this.type, 0);
    }

    Object findValue(int ordinal) {
        return this.getValue(ordinal, this.type, 0);
    }

    private Object getValue(int ordinal, String type, int fieldIndex) {
        Object value = null;
        HollowTypeDataAccess typeDataAccess = this.hollowDataAccess.getTypeDataAccess(type);
        HollowSchema.SchemaType schemaType = this.hollowDataAccess.getSchema(type).getSchemaType();
        HollowSchema schema = this.hollowDataAccess.getSchema(type);
        if (schemaType.equals((Object)HollowSchema.SchemaType.LIST) || schemaType.equals((Object)HollowSchema.SchemaType.SET)) {
            HollowCollectionTypeDataAccess collectionTypeDataAccess = (HollowCollectionTypeDataAccess)typeDataAccess;
            HollowCollectionSchema collectionSchema = (HollowCollectionSchema)schema;
            String elementType = collectionSchema.getElementType();
            HollowOrdinalIterator it = collectionTypeDataAccess.ordinalIterator(ordinal);
            int refOrdinal = it.next();
            if (refOrdinal != Integer.MAX_VALUE) {
                value = this.getValue(refOrdinal, elementType, fieldIndex + 1);
            }
            return value;
        }
        if (schemaType.equals((Object)HollowSchema.SchemaType.MAP)) {
            HollowMapTypeDataAccess mapTypeDataAccess = (HollowMapTypeDataAccess)typeDataAccess;
            HollowMapSchema mapSchema = (HollowMapSchema)schema;
            boolean iterateThroughKeys = this.fields[fieldIndex].equals("key");
            String keyOrValueType = iterateThroughKeys ? mapSchema.getKeyType() : mapSchema.getValueType();
            HollowMapEntryOrdinalIterator mapEntryIterator = mapTypeDataAccess.ordinalIterator(ordinal);
            if (mapEntryIterator.next()) {
                int keyOrValueOrdinal = iterateThroughKeys ? mapEntryIterator.getKey() : mapEntryIterator.getValue();
                value = this.getValue(keyOrValueOrdinal, keyOrValueType, fieldIndex + 1);
            }
            return value;
        }
        HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
        HollowObjectTypeDataAccess objectTypeDataAccess = (HollowObjectTypeDataAccess)typeDataAccess;
        if (this.fieldTypes[fieldIndex].equals((Object)HollowObjectSchema.FieldType.REFERENCE)) {
            int refOrdinal = objectTypeDataAccess.readOrdinal(ordinal, this.fieldPositions[fieldIndex]);
            if (refOrdinal >= 0) {
                String refType = objectSchema.getReferencedType(this.fieldPositions[fieldIndex]);
                value = this.getValue(refOrdinal, refType, fieldIndex + 1);
            }
        } else {
            value = this.readFromObject(objectTypeDataAccess, ordinal, this.fieldTypes[fieldIndex], this.fieldPositions[fieldIndex]);
        }
        return value;
    }

    private Object[] getAllValues(int ordinal, String type, int fieldIndex) {
        Object[] values;
        HollowTypeDataAccess typeDataAccess = this.hollowDataAccess.getTypeDataAccess(type);
        HollowSchema.SchemaType schemaType = this.hollowDataAccess.getSchema(type).getSchemaType();
        HollowSchema schema = this.hollowDataAccess.getSchema(type);
        if (schemaType.equals((Object)HollowSchema.SchemaType.LIST) || schemaType.equals((Object)HollowSchema.SchemaType.SET)) {
            HollowCollectionTypeDataAccess collectionTypeDataAccess = (HollowCollectionTypeDataAccess)typeDataAccess;
            HollowCollectionSchema collectionSchema = (HollowCollectionSchema)schema;
            String elementType = collectionSchema.getElementType();
            HollowOrdinalIterator it = collectionTypeDataAccess.ordinalIterator(ordinal);
            ArrayList<Object> valueList = new ArrayList<Object>();
            int refOrdinal = it.next();
            while (refOrdinal != Integer.MAX_VALUE) {
                Object[] refValues;
                for (Object value : refValues = this.getAllValues(refOrdinal, elementType, fieldIndex + 1)) {
                    valueList.add(value);
                }
                refOrdinal = it.next();
            }
            values = new Object[valueList.size()];
            valueList.toArray(values);
        } else if (schemaType.equals((Object)HollowSchema.SchemaType.MAP)) {
            HollowMapTypeDataAccess mapTypeDataAccess = (HollowMapTypeDataAccess)typeDataAccess;
            HollowMapSchema mapSchema = (HollowMapSchema)schema;
            boolean iterateThroughKeys = this.fields[fieldIndex].equals("key");
            String keyOrValueType = iterateThroughKeys ? mapSchema.getKeyType() : mapSchema.getValueType();
            HollowMapEntryOrdinalIterator mapEntryIterator = mapTypeDataAccess.ordinalIterator(ordinal);
            ArrayList<Object> valueList = new ArrayList<Object>();
            while (mapEntryIterator.next()) {
                Object[] refValues;
                int keyOrValueOrdinal = iterateThroughKeys ? mapEntryIterator.getKey() : mapEntryIterator.getValue();
                for (Object value : refValues = this.getAllValues(keyOrValueOrdinal, keyOrValueType, fieldIndex + 1)) {
                    valueList.add(value);
                }
            }
            values = new Object[valueList.size()];
            valueList.toArray(values);
        } else {
            HollowObjectSchema objectSchema = (HollowObjectSchema)schema;
            HollowObjectTypeDataAccess objectTypeDataAccess = (HollowObjectTypeDataAccess)typeDataAccess;
            if (this.fieldTypes[fieldIndex].equals((Object)HollowObjectSchema.FieldType.REFERENCE)) {
                int refOrdinal = objectTypeDataAccess.readOrdinal(ordinal, this.fieldPositions[fieldIndex]);
                if (refOrdinal >= 0) {
                    String refType = objectSchema.getReferencedType(this.fieldPositions[fieldIndex]);
                    return this.getAllValues(refOrdinal, refType, fieldIndex + 1);
                }
                return new Object[0];
            }
            return new Object[]{this.readFromObject(objectTypeDataAccess, ordinal, this.fieldTypes[fieldIndex], this.fieldPositions[fieldIndex])};
        }
        return values;
    }

    private Object readFromObject(HollowObjectTypeDataAccess objectTypeDataAccess, int ordinal, HollowObjectSchema.FieldType fieldType, int fieldPosition) {
        Object value;
        switch (fieldType) {
            case INT: {
                value = objectTypeDataAccess.readInt(ordinal, fieldPosition);
                break;
            }
            case LONG: {
                value = objectTypeDataAccess.readLong(ordinal, fieldPosition);
                break;
            }
            case DOUBLE: {
                value = objectTypeDataAccess.readDouble(ordinal, fieldPosition);
                break;
            }
            case FLOAT: {
                value = Float.valueOf(objectTypeDataAccess.readFloat(ordinal, fieldPosition));
                break;
            }
            case BOOLEAN: {
                value = objectTypeDataAccess.readBoolean(ordinal, fieldPosition);
                break;
            }
            case STRING: {
                value = objectTypeDataAccess.readString(ordinal, fieldPosition);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid field type :" + (Object)((Object)fieldType) + " cannot read values for this type");
            }
        }
        return value;
    }
}

