/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.sampling;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowSampler;
import com.netflix.hollow.api.sampling.HollowSamplingDirector;
import com.netflix.hollow.api.sampling.SampleResult;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import java.util.ArrayList;
import java.util.Collection;

public class HollowMapSampler
implements HollowSampler {
    public static final HollowMapSampler NULL_SAMPLER = new HollowMapSampler("", DisabledSamplingDirector.INSTANCE);
    private final String typeName;
    private HollowSamplingDirector director;
    private long sizeSamples;
    private long getSamples;
    private long bucketRetrievalSamples;
    private long iteratorSamples;

    public HollowMapSampler(String typeName, HollowSamplingDirector director) {
        this.typeName = typeName;
        this.director = director;
    }

    @Override
    public void setSamplingDirector(HollowSamplingDirector director) {
        if (!"".equals(this.typeName)) {
            this.director = director;
        }
    }

    @Override
    public void setFieldSpecificSamplingDirector(HollowFilterConfig fieldSpec, HollowSamplingDirector director) {
        if (!"".equals(this.typeName) && fieldSpec.doesIncludeType(this.typeName)) {
            this.director = director;
        }
    }

    @Override
    public void setUpdateThread(Thread t) {
        this.director.setUpdateThread(t);
    }

    public void recordSize() {
        if (this.director.shouldRecord()) {
            ++this.sizeSamples;
        }
    }

    public void recordBucketRetrieval() {
        if (this.director.shouldRecord()) {
            ++this.bucketRetrievalSamples;
        }
    }

    public void recordGet() {
        if (this.director.shouldRecord()) {
            ++this.getSamples;
        }
    }

    public void recordIterator() {
        if (this.director.shouldRecord()) {
            ++this.iteratorSamples;
        }
    }

    @Override
    public boolean hasSampleResults() {
        return this.sizeSamples > 0L || this.getSamples > 0L || this.iteratorSamples > 0L || this.bucketRetrievalSamples > 0L;
    }

    @Override
    public Collection<SampleResult> getSampleResults() {
        ArrayList<SampleResult> sampleResults = new ArrayList<SampleResult>(4);
        sampleResults.add(new SampleResult(this.typeName + ".size()", this.sizeSamples));
        sampleResults.add(new SampleResult(this.typeName + ".get()", this.getSamples));
        sampleResults.add(new SampleResult(this.typeName + ".iterator()", this.iteratorSamples));
        sampleResults.add(new SampleResult(this.typeName + ".bucketValue()", this.bucketRetrievalSamples));
        return sampleResults;
    }

    @Override
    public void reset() {
        this.sizeSamples = 0L;
        this.getSamples = 0L;
        this.iteratorSamples = 0L;
        this.bucketRetrievalSamples = 0L;
    }
}

