/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import java.util.function.Supplier;

public class RecordCountVarianceValidator
implements ValidatorListener {
    private static final String ZERO_PREVIOUS_COUNT_WARN_MSG_FORMAT = "Previous record count is 0. Not running RecordCountVarianceValidator for type %s. This scenario is not expected except when starting a new namespace.";
    private static final String FAILED_RECORD_COUNT_VALIDATION = "Record count validation for type %s has failed as actual change percent %s is greater than allowed change percent %s.";
    private static final String NULL_THRESHOLD = "Record count validation for type %s has failed because the variance threshold was null.";
    private static final String DATA_TYPE_NAME = "Typename";
    private static final String ALLOWABLE_VARIANCE_PERCENT_NAME = "AllowableVariancePercent";
    private static final String LATEST_CARDINALITY_NAME = "LatestRecordCount";
    private static final String PREVIOUS_CARDINALITY_NAME = "PreviousRecordCount";
    private static final String ACTUAL_CHANGE_PERCENT_NAME = "ActualChangePercent";
    private static final String NAME = RecordCountVarianceValidator.class.getName();
    private final String typeName;
    private final Supplier<Float> allowableVariancePercentSupplier;

    public RecordCountVarianceValidator(String typeName, float allowableVariancePercent) {
        this(typeName, () -> Float.valueOf(allowableVariancePercent));
    }

    public RecordCountVarianceValidator(String typeName, Supplier<Float> allowableVariancePercentSupplier) {
        this.typeName = typeName;
        this.allowableVariancePercentSupplier = allowableVariancePercentSupplier;
        Float allowableVariancePercent = allowableVariancePercentSupplier.get();
        if (allowableVariancePercent == null || allowableVariancePercent.floatValue() < 0.0f) {
            throw new IllegalArgumentException("RecordCountVarianceValidator for type " + typeName + ": cannot have allowableVariancePercent be null or less than 0. Value provided: " + allowableVariancePercent);
        }
    }

    @Override
    public String getName() {
        return NAME + "_" + this.typeName;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        ValidationResult.ValidationResultBuilder vrb = ValidationResult.from(this);
        Float allowableVariancePercent = this.allowableVariancePercentSupplier.get();
        if (allowableVariancePercent == null) {
            String message = String.format(NULL_THRESHOLD, this.typeName);
            return vrb.failed(message);
        }
        vrb.detail(ALLOWABLE_VARIANCE_PERCENT_NAME, allowableVariancePercent).detail(DATA_TYPE_NAME, this.typeName);
        HollowTypeReadState typeState = readState.getStateEngine().getTypeState(this.typeName);
        int latestCardinality = typeState.getPopulatedOrdinals().cardinality();
        int previousCardinality = typeState.getPreviousOrdinals().cardinality();
        vrb.detail(LATEST_CARDINALITY_NAME, latestCardinality).detail(PREVIOUS_CARDINALITY_NAME, previousCardinality);
        if (previousCardinality == 0) {
            return vrb.detail("skipped", Boolean.TRUE).passed(String.format(ZERO_PREVIOUS_COUNT_WARN_MSG_FORMAT, this.typeName));
        }
        float actualChangePercent = this.getChangePercent(latestCardinality, previousCardinality);
        vrb.detail(ACTUAL_CHANGE_PERCENT_NAME, Float.valueOf(actualChangePercent));
        if (Float.compare(actualChangePercent, allowableVariancePercent.floatValue()) > 0) {
            String message = String.format(FAILED_RECORD_COUNT_VALIDATION, this.typeName, Float.valueOf(actualChangePercent), allowableVariancePercent);
            return vrb.failed(message);
        }
        return vrb.passed();
    }

    float getChangePercent(int latestCardinality, int previousCardinality) {
        int diff = Math.abs(latestCardinality - previousCardinality);
        return 100.0f * (float)diff / (float)previousCardinality;
    }
}

