/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.validation;

import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.objects.HollowObject;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.validation.ValidationResult;
import com.netflix.hollow.api.producer.validation.ValidatorListener;
import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class ObjectModificationValidator<A extends HollowAPI, T extends HollowObject>
implements ValidatorListener {
    private final String typeName;
    private final Function<HollowDataAccess, A> apiFunction;
    private final BiFunction<A, Integer, T> hollowObjectFunction;
    private final BiPredicate<T, T> filter;

    public ObjectModificationValidator(String typeName, BiPredicate<T, T> filter, Function<HollowDataAccess, A> apiFunction, BiFunction<A, Integer, T> hollowObjectFunction) {
        this.typeName = typeName;
        this.filter = filter;
        this.apiFunction = apiFunction;
        this.hollowObjectFunction = hollowObjectFunction;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName() + "_" + this.typeName;
    }

    @Override
    public ValidationResult onValidate(HollowProducer.ReadState readState) {
        ValidationResult.ValidationResultBuilder vrb = ValidationResult.from(this).detail("Typename", this.typeName);
        HollowTypeReadState typeState = readState.getStateEngine().getTypeState(this.typeName);
        if (typeState == null) {
            return vrb.failed("Cannot execute ObjectModificationValidator on missing type " + this.typeName);
        }
        if (typeState.getSchema().getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            return vrb.failed("Cannot execute ObjectModificationValidator on type " + this.typeName + " because it is not a HollowObjectSchema - it is a " + (Object)((Object)typeState.getSchema().getSchemaType()));
        }
        BitSet latestOrdinals = typeState.getPopulatedOrdinals();
        BitSet previousOrdinals = typeState.getPreviousOrdinals();
        if (previousOrdinals.isEmpty()) {
            return vrb.detail("skipped", Boolean.TRUE).passed("Nothing to do because previous cycle has no " + this.typeName);
        }
        BitSet removedAndModified = ObjectModificationValidator.calculateRemovedAndModifiedOrdinals(latestOrdinals, previousOrdinals);
        if (removedAndModified.isEmpty()) {
            return vrb.detail("skipped", Boolean.TRUE).passed("Nothing to do because " + this.typeName + " has no removals or modifications");
        }
        HollowAPI hollowApi = (HollowAPI)this.apiFunction.apply(readState.getStateEngine());
        HollowObjectTypeReadState objectTypeState = (HollowObjectTypeReadState)typeState;
        PrimaryKey key = objectTypeState.getSchema().getPrimaryKey();
        HollowPrimaryKeyIndex index = new HollowPrimaryKeyIndex(readState.getStateEngine(), key);
        int fromOrdinal = removedAndModified.nextSetBit(0);
        while (fromOrdinal != -1) {
            HollowObject toObject;
            HollowObject fromObject;
            Object[] candidateKey = index.getRecordKey(fromOrdinal);
            int matchedOrdinal = index.getMatchingOrdinal(candidateKey);
            if (matchedOrdinal != -1 && !this.filter.test(fromObject = (HollowObject)this.hollowObjectFunction.apply(hollowApi, fromOrdinal), toObject = (HollowObject)this.hollowObjectFunction.apply(hollowApi, matchedOrdinal))) {
                return vrb.detail("candidateKey", Arrays.toString(candidateKey)).detail("fromOrdinal", fromOrdinal).detail("toOrdinal", matchedOrdinal).failed("Validation failed for candidate key");
            }
            fromOrdinal = removedAndModified.nextSetBit(fromOrdinal + 1);
        }
        return vrb.passed();
    }

    private static BitSet calculateRemovedAndModifiedOrdinals(BitSet latestOrdinals, BitSet previousOrdinals) {
        BitSet removedAndModified = new BitSet();
        removedAndModified.or(previousOrdinals);
        removedAndModified.andNot(latestOrdinals);
        return removedAndModified;
    }
}

