/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.metrics;

import java.util.Optional;
import java.util.OptionalLong;

public class CycleMetrics {
    private long consecutiveFailures;
    private OptionalLong cycleDurationMillis;
    private Optional<Boolean> isCycleSuccess;
    private OptionalLong lastCycleSuccessTimeNano;

    public long getConsecutiveFailures() {
        return this.consecutiveFailures;
    }

    public OptionalLong getCycleDurationMillis() {
        return this.cycleDurationMillis;
    }

    public Optional<Boolean> getIsCycleSuccess() {
        return this.isCycleSuccess;
    }

    public OptionalLong getLastCycleSuccessTimeNano() {
        return this.lastCycleSuccessTimeNano;
    }

    private CycleMetrics(Builder builder) {
        this.consecutiveFailures = builder.consecutiveFailures;
        this.cycleDurationMillis = builder.cycleDurationMillis;
        this.isCycleSuccess = builder.isCycleSuccess;
        this.lastCycleSuccessTimeNano = builder.lastCycleSuccessTimeNano;
    }

    public static final class Builder {
        private long consecutiveFailures;
        private OptionalLong cycleDurationMillis;
        private Optional<Boolean> isCycleSuccess = Optional.empty();
        private OptionalLong lastCycleSuccessTimeNano;

        public Builder() {
            this.cycleDurationMillis = OptionalLong.empty();
            this.lastCycleSuccessTimeNano = OptionalLong.empty();
        }

        public Builder setConsecutiveFailures(long consecutiveFailures) {
            this.consecutiveFailures = consecutiveFailures;
            return this;
        }

        public Builder setCycleDurationMillis(long cycleDurationMillis) {
            this.cycleDurationMillis = OptionalLong.of(cycleDurationMillis);
            return this;
        }

        public Builder setIsCycleSuccess(boolean isCycleSuccess) {
            this.isCycleSuccess = Optional.of(isCycleSuccess);
            return this;
        }

        public Builder setLastCycleSuccessTimeNano(long lastCycleSuccessTimeNano) {
            this.lastCycleSuccessTimeNano = OptionalLong.of(lastCycleSuccessTimeNano);
            return this;
        }

        public CycleMetrics build() {
            return new CycleMetrics(this);
        }
    }
}

