/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.metrics;

import java.util.Map;
import java.util.OptionalLong;

public class AnnouncementMetrics {
    private long dataSizeBytes;
    private Map<String, Integer> numShardsPerType;
    private Map<String, Long> shardSizePerType;
    private long announcementDurationMillis;
    private boolean isAnnouncementSuccess;
    private OptionalLong lastAnnouncementSuccessTimeNano;
    private OptionalLong deltaChainVersionCounter;

    public long getDataSizeBytes() {
        return this.dataSizeBytes;
    }

    public Map<String, Integer> getNumShardsPerType() {
        return this.numShardsPerType;
    }

    public Map<String, Long> getShardSizePerType() {
        return this.shardSizePerType;
    }

    public long getAnnouncementDurationMillis() {
        return this.announcementDurationMillis;
    }

    public boolean getIsAnnouncementSuccess() {
        return this.isAnnouncementSuccess;
    }

    public OptionalLong getLastAnnouncementSuccessTimeNano() {
        return this.lastAnnouncementSuccessTimeNano;
    }

    public OptionalLong getDeltaChainVersionCounter() {
        return this.deltaChainVersionCounter;
    }

    private AnnouncementMetrics(Builder builder) {
        this.dataSizeBytes = builder.dataSizeBytes;
        this.numShardsPerType = builder.numShardsPerType;
        this.shardSizePerType = builder.shardSizePerType;
        this.announcementDurationMillis = builder.announcementDurationMillis;
        this.isAnnouncementSuccess = builder.isAnnouncementSuccess;
        this.lastAnnouncementSuccessTimeNano = builder.lastAnnouncementSuccessTimeNano;
        this.deltaChainVersionCounter = builder.deltaChainVersionCounter;
    }

    public static final class Builder {
        private long dataSizeBytes;
        private long announcementDurationMillis;
        private boolean isAnnouncementSuccess;
        private OptionalLong lastAnnouncementSuccessTimeNano = OptionalLong.empty();
        private OptionalLong deltaChainVersionCounter = OptionalLong.empty();
        private Map<String, Integer> numShardsPerType;
        private Map<String, Long> shardSizePerType;

        public Builder setDataSizeBytes(long dataSizeBytes) {
            this.dataSizeBytes = dataSizeBytes;
            return this;
        }

        public Builder setNumShardsPerType(Map<String, Integer> numShardsPerType) {
            this.numShardsPerType = numShardsPerType;
            return this;
        }

        public Builder setShardSizePerType(Map<String, Long> shardSizePerType) {
            this.shardSizePerType = shardSizePerType;
            return this;
        }

        public Builder setAnnouncementDurationMillis(long announcementDurationMillis) {
            this.announcementDurationMillis = announcementDurationMillis;
            return this;
        }

        public Builder setIsAnnouncementSuccess(boolean isAnnouncementSuccess) {
            this.isAnnouncementSuccess = isAnnouncementSuccess;
            return this;
        }

        public Builder setLastAnnouncementSuccessTimeNano(long lastAnnouncementSuccessTimeNano) {
            this.lastAnnouncementSuccessTimeNano = OptionalLong.of(lastAnnouncementSuccessTimeNano);
            return this;
        }

        public Builder setDeltaChainVersionCounter(long deltaChainVersionCounter) {
            this.deltaChainVersionCounter = OptionalLong.of(deltaChainVersionCounter);
            return this;
        }

        public AnnouncementMetrics build() {
            return new AnnouncementMetrics(this);
        }
    }
}

