/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer.metrics;

import com.netflix.hollow.api.producer.AbstractHollowProducerListener;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.api.producer.Status;
import com.netflix.hollow.api.producer.listener.CycleListener;
import com.netflix.hollow.api.producer.metrics.AnnouncementMetrics;
import com.netflix.hollow.api.producer.metrics.CycleMetrics;
import com.netflix.hollow.api.producer.metrics.ProducerMetricsReporting;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import java.time.Duration;
import java.util.Map;
import java.util.OptionalLong;

public abstract class AbstractProducerMetricsListener
extends AbstractHollowProducerListener
implements ProducerMetricsReporting {
    private AnnouncementMetrics.Builder announcementMetricsBuilder;
    private long consecutiveFailures = 0L;
    OptionalLong lastCycleSuccessTimeNanoOptional = OptionalLong.empty();
    OptionalLong lastAnnouncementSuccessTimeNanoOptional = OptionalLong.empty();

    @Override
    public void onAnnouncementStart(long version) {
        this.announcementMetricsBuilder = new AnnouncementMetrics.Builder();
    }

    @Override
    public void onCycleSkip(CycleListener.CycleSkipReason reason) {
        CycleMetrics.Builder cycleMetricsBuilder = new CycleMetrics.Builder();
        cycleMetricsBuilder.setConsecutiveFailures(this.consecutiveFailures);
        this.lastCycleSuccessTimeNanoOptional.ifPresent(cycleMetricsBuilder::setLastCycleSuccessTimeNano);
        this.cycleMetricsReporting(cycleMetricsBuilder.build());
    }

    @Override
    public void onAnnouncementComplete(Status status, HollowProducer.ReadState readState, long version, Duration elapsed) {
        boolean isAnnouncementSuccess = false;
        long dataSizeBytes = 0L;
        if (status.getType() == Status.StatusType.SUCCESS) {
            isAnnouncementSuccess = true;
            this.lastAnnouncementSuccessTimeNanoOptional = OptionalLong.of(System.nanoTime());
        }
        HollowReadStateEngine stateEngine = readState.getStateEngine();
        dataSizeBytes = stateEngine.calcApproxDataSize();
        Map<String, Integer> numShardsPerType = stateEngine.numShardsPerType();
        Map<String, Long> shardSizePerType = stateEngine.calcApproxShardSizePerType();
        this.announcementMetricsBuilder.setDataSizeBytes(dataSizeBytes).setNumShardsPerType(numShardsPerType).setShardSizePerType(shardSizePerType).setIsAnnouncementSuccess(isAnnouncementSuccess).setAnnouncementDurationMillis(elapsed.toMillis());
        this.lastAnnouncementSuccessTimeNanoOptional.ifPresent(this.announcementMetricsBuilder::setLastAnnouncementSuccessTimeNano);
        if (stateEngine.getHeaderTag("hollow.delta.chain.version.counter") != null) {
            try {
                long deltaChainVersionCounter = Long.parseLong(stateEngine.getHeaderTag("hollow.delta.chain.version.counter"));
                this.announcementMetricsBuilder.setDeltaChainVersionCounter(deltaChainVersionCounter);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.announcementMetricsReporting(this.announcementMetricsBuilder.build());
    }

    @Override
    public void onCycleComplete(Status status, HollowProducer.ReadState readState, long version, Duration elapsed) {
        boolean isCycleSuccess;
        long cycleEndTimeNano = System.nanoTime();
        if (status.getType() == Status.StatusType.SUCCESS) {
            isCycleSuccess = true;
            this.consecutiveFailures = 0L;
            this.lastCycleSuccessTimeNanoOptional = OptionalLong.of(cycleEndTimeNano);
        } else {
            isCycleSuccess = false;
            ++this.consecutiveFailures;
        }
        CycleMetrics.Builder cycleMetricsBuilder = new CycleMetrics.Builder().setConsecutiveFailures(this.consecutiveFailures).setCycleDurationMillis(elapsed.toMillis()).setIsCycleSuccess(isCycleSuccess);
        this.lastCycleSuccessTimeNanoOptional.ifPresent(cycleMetricsBuilder::setLastCycleSuccessTimeNano);
        this.cycleMetricsReporting(cycleMetricsBuilder.build());
    }
}

