/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;

final class ReadStateHelper {
    private final HollowProducer.ReadState current;
    private final HollowProducer.ReadState pending;

    static ReadStateHelper newDeltaChain() {
        return new ReadStateHelper(null, null);
    }

    static ReadStateHelper restored(HollowProducer.ReadState state) {
        return new ReadStateHelper(state, null);
    }

    static HollowProducer.ReadState newReadState(final long version, final HollowReadStateEngine stateEngine) {
        return new HollowProducer.ReadState(){

            @Override
            public long getVersion() {
                return version;
            }

            @Override
            public HollowReadStateEngine getStateEngine() {
                return stateEngine;
            }
        };
    }

    private ReadStateHelper(HollowProducer.ReadState current, HollowProducer.ReadState pending) {
        this.current = current;
        this.pending = pending;
    }

    ReadStateHelper roundtrip(long version) {
        if (this.pending != null) {
            throw new IllegalStateException();
        }
        return new ReadStateHelper(this.current, ReadStateHelper.newReadState(version, new HollowReadStateEngine()));
    }

    ReadStateHelper swap() {
        return new ReadStateHelper(ReadStateHelper.newReadState(this.current.getVersion(), this.pending.getStateEngine()), ReadStateHelper.newReadState(this.pending.getVersion(), this.current.getStateEngine()));
    }

    ReadStateHelper commit() {
        if (this.pending == null) {
            throw new IllegalStateException();
        }
        return new ReadStateHelper(this.pending, null);
    }

    ReadStateHelper rollback() {
        if (this.pending == null) {
            throw new IllegalStateException();
        }
        return new ReadStateHelper(ReadStateHelper.newReadState(this.current.getVersion(), this.pending.getStateEngine()), null);
    }

    HollowProducer.ReadState current() {
        return this.current;
    }

    boolean hasCurrent() {
        return this.current != null;
    }

    HollowProducer.ReadState pending() {
        return this.pending;
    }

    long pendingVersion() {
        return this.pending != null ? this.pending.getVersion() : Long.MIN_VALUE;
    }
}

