/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.producer;

import com.netflix.hollow.api.producer.HollowIncrementalCyclePopulator;
import com.netflix.hollow.api.producer.HollowProducer;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import java.util.concurrent.ConcurrentHashMap;

final class CloseableIncrementalWriteState
implements HollowProducer.Incremental.IncrementalWriteState,
AutoCloseable {
    private final ConcurrentHashMap<RecordPrimaryKey, Object> events;
    private final HollowObjectMapper objectMapper;
    private volatile boolean closed;

    public CloseableIncrementalWriteState(ConcurrentHashMap<RecordPrimaryKey, Object> events, HollowObjectMapper objectMapper) {
        this.events = events;
        this.objectMapper = objectMapper;
    }

    @Override
    public void addOrModify(Object o) {
        this.ensureNotClosed();
        this.events.put(this.getKey(o), o);
    }

    @Override
    public void addIfAbsent(Object o) {
        this.ensureNotClosed();
        this.events.putIfAbsent(this.getKey(o), new HollowIncrementalCyclePopulator.AddIfAbsent(o));
    }

    @Override
    public void delete(Object o) {
        this.delete(this.getKey(o));
    }

    @Override
    public void delete(RecordPrimaryKey key) {
        this.ensureNotClosed();
        this.events.put(key, HollowIncrementalCyclePopulator.DELETE_RECORD);
    }

    private RecordPrimaryKey getKey(Object o) {
        if (o instanceof FlatRecord) {
            FlatRecord fr = (FlatRecord)o;
            return fr.getRecordPrimaryKey();
        }
        return this.objectMapper.extractPrimaryKey(o);
    }

    private void ensureNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Write state operated on after the incremental population stage of a cycle");
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

