/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.schema.HollowSchema;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowPerformanceAPI
extends HollowAPI {
    protected final PerfAPITypeIdentifiers types;

    public HollowPerformanceAPI(HollowDataAccess dataAccess) {
        super(dataAccess);
        this.types = new PerfAPITypeIdentifiers(dataAccess);
    }

    public PerfAPITypeIdentifiers getTypeIdentifiers() {
        return this.types;
    }

    public static class PerfAPITypeIdentifiers {
        private final String[] typeNames;
        private final Map<String, Integer> typeIdxMap;

        public PerfAPITypeIdentifiers(HollowDataset dataset) {
            List<HollowSchema> schemas = dataset.getSchemas();
            this.typeIdxMap = new HashMap<String, Integer>();
            String[] typeNames = new String[schemas.size()];
            for (int i = 0; i < schemas.size(); ++i) {
                typeNames[i] = schemas.get(i).getName();
                this.typeIdxMap.put(typeNames[i], i);
            }
            this.typeNames = typeNames;
        }

        public int getIdx(String typeName) {
            Integer idx = this.typeIdxMap.get(typeName);
            if (idx == null) {
                return -1;
            }
            return idx;
        }

        public String getTypeName(int idx) {
            if (idx >= 0 && idx < this.typeNames.length) {
                return this.typeNames[idx];
            }
            return "INVALID (" + idx + ")";
        }
    }
}

