/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HashKeyExtractor;
import com.netflix.hollow.api.perfapi.HollowSetTypePerfAPI;
import com.netflix.hollow.api.perfapi.POJOInstantiator;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class HollowPerfBackedSet<T>
extends AbstractSet<T> {
    private final int ordinal;
    private final HollowSetTypeDataAccess dataAccess;
    private final long elementMaskedTypeIdx;
    private final POJOInstantiator<T> instantiator;
    private final HashKeyExtractor hashKeyExtractor;

    public HollowPerfBackedSet(HollowSetTypePerfAPI typeApi, long ref, POJOInstantiator<T> instantiator, HashKeyExtractor hashKeyExtractor) {
        this.dataAccess = typeApi.typeAccess();
        this.ordinal = typeApi.ordinal(ref);
        this.instantiator = instantiator;
        this.elementMaskedTypeIdx = typeApi.elementMaskedTypeIdx;
        this.hashKeyExtractor = hashKeyExtractor;
    }

    @Override
    public Iterator<T> iterator() {
        final HollowOrdinalIterator oi = this.dataAccess.ordinalIterator(this.ordinal);
        return new Iterator<T>(){
            int eo;
            {
                this.eo = oi.next();
            }

            @Override
            public boolean hasNext() {
                return this.eo != Integer.MAX_VALUE;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                int o = this.eo;
                this.eo = oi.next();
                return HollowPerfBackedSet.this.instantiator.instantiate(HollowPerfBackedSet.this.elementMaskedTypeIdx | (long)o);
            }
        };
    }

    @Override
    public boolean contains(Object o) {
        if (this.hashKeyExtractor == null) {
            throw new UnsupportedOperationException();
        }
        Object[] key = this.hashKeyExtractor.extractArray(o);
        if (key == null) {
            return false;
        }
        return this.dataAccess.findElement(this.ordinal, key) != -1;
    }

    @Override
    public int size() {
        return this.dataAccess.size(this.ordinal);
    }
}

