/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.perfapi;

import com.netflix.hollow.api.perfapi.HashKeyExtractor;
import com.netflix.hollow.api.perfapi.HollowPerfBackedMap;
import com.netflix.hollow.api.perfapi.HollowPerfMapEntryIterator;
import com.netflix.hollow.api.perfapi.HollowPerformanceAPI;
import com.netflix.hollow.api.perfapi.HollowTypePerfAPI;
import com.netflix.hollow.api.perfapi.POJOInstantiator;
import com.netflix.hollow.api.perfapi.Ref;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.dataaccess.missing.HollowMapMissingDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import java.util.Map;

public class HollowMapTypePerfAPI
extends HollowTypePerfAPI {
    private final HollowMapTypeDataAccess typeAccess;
    final long keyMaskedTypeIdx;
    final long valueMaskedTypeIdx;

    public HollowMapTypePerfAPI(HollowDataAccess dataAccess, String typeName, HollowPerformanceAPI api) {
        super(typeName, api);
        HollowMapTypeDataAccess typeAccess = (HollowMapTypeDataAccess)dataAccess.getTypeDataAccess(typeName);
        int keyTypeIdx = typeAccess == null ? -1 : api.types.getIdx(typeAccess.getSchema().getKeyType());
        int valueTypeIdx = typeAccess == null ? -1 : api.types.getIdx(typeAccess.getSchema().getValueType());
        this.keyMaskedTypeIdx = Ref.toTypeMasked(keyTypeIdx);
        this.valueMaskedTypeIdx = Ref.toTypeMasked(valueTypeIdx);
        if (typeAccess == null) {
            typeAccess = new HollowMapMissingDataAccess(dataAccess, typeName);
        }
        this.typeAccess = typeAccess;
    }

    public int size(long ref) {
        return this.typeAccess.size(this.ordinal(ref));
    }

    public HollowPerfMapEntryIterator possibleMatchIter(long ref, int hashCode) {
        HollowMapEntryOrdinalIterator iter = this.typeAccess.potentialMatchOrdinalIterator(this.ordinal(ref), hashCode);
        return new HollowPerfMapEntryIterator(iter, this.keyMaskedTypeIdx, this.valueMaskedTypeIdx);
    }

    public HollowPerfMapEntryIterator iterator(long ref) {
        HollowMapEntryOrdinalIterator iter = this.typeAccess.ordinalIterator(this.ordinal(ref));
        return new HollowPerfMapEntryIterator(iter, this.keyMaskedTypeIdx, this.valueMaskedTypeIdx);
    }

    public long findKey(long ref, Object ... hashKey) {
        int ordinal = this.typeAccess.findKey(this.ordinal(ref), hashKey);
        return Ref.toRefWithTypeMasked(this.keyMaskedTypeIdx, ordinal);
    }

    public long findValue(long ref, Object ... hashKey) {
        int ordinal = this.typeAccess.findValue(this.ordinal(ref), hashKey);
        return Ref.toRefWithTypeMasked(this.valueMaskedTypeIdx, ordinal);
    }

    public <K, V> Map<K, V> backedMap(long ref, POJOInstantiator<K> keyInstantiator, POJOInstantiator<V> valueInstantiator, HashKeyExtractor hashKeyExtractor) {
        return new HollowPerfBackedMap<K, V>(this, this.ordinal(ref), keyInstantiator, valueInstantiator, hashKeyExtractor);
    }

    @Override
    public HollowMapTypeDataAccess typeAccess() {
        return this.typeAccess;
    }
}

