/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects.delegate;

import com.netflix.hollow.api.custom.HollowSetTypeAPI;
import com.netflix.hollow.api.objects.HollowSet;
import com.netflix.hollow.api.objects.delegate.HollowSetDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowSetSchema;

public class HollowSetLookupDelegate<T>
implements HollowSetDelegate<T> {
    private final HollowSetTypeDataAccess dataAccess;
    protected final HollowSetTypeAPI typeAPI;

    public HollowSetLookupDelegate(HollowSetTypeDataAccess dataAccess) {
        this(dataAccess, null);
    }

    public HollowSetLookupDelegate(HollowSetTypeAPI typeAPI) {
        this(typeAPI.getTypeDataAccess(), typeAPI);
    }

    private HollowSetLookupDelegate(HollowSetTypeDataAccess dataAccess, HollowSetTypeAPI typeAPI) {
        this.dataAccess = dataAccess;
        this.typeAPI = typeAPI;
    }

    @Override
    public int size(int ordinal) {
        return this.dataAccess.size(ordinal);
    }

    @Override
    public boolean contains(HollowSet<T> set, int ordinal, Object o) {
        HollowOrdinalIterator iter;
        if (this.getSchema().getHashKey() != null) {
            iter = this.dataAccess.ordinalIterator(ordinal);
        } else {
            int hashCode = this.dataAccess.getDataAccess().getHashCodeFinder().hashCode(o);
            iter = this.dataAccess.potentialMatchOrdinalIterator(ordinal, hashCode);
        }
        int potentialOrdinal = iter.next();
        while (potentialOrdinal != Integer.MAX_VALUE) {
            if (set.equalsElement(potentialOrdinal, o)) {
                return true;
            }
            potentialOrdinal = iter.next();
        }
        return false;
    }

    @Override
    public T findElement(HollowSet<T> set, int ordinal, Object ... keys) {
        int elementOrdinal = this.dataAccess.findElement(ordinal, keys);
        if (elementOrdinal != -1) {
            return set.instantiateElement(elementOrdinal);
        }
        return null;
    }

    @Override
    public HollowOrdinalIterator iterator(int ordinal) {
        return this.dataAccess.ordinalIterator(ordinal);
    }

    @Override
    public HollowSetSchema getSchema() {
        return this.dataAccess.getSchema();
    }

    @Override
    public HollowSetTypeDataAccess getTypeDataAccess() {
        return this.dataAccess;
    }

    @Override
    public HollowSetTypeAPI getTypeAPI() {
        return this.typeAPI;
    }
}

