/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.objects;

import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.api.objects.delegate.HollowObjectDelegate;
import com.netflix.hollow.api.objects.delegate.HollowRecordDelegate;
import com.netflix.hollow.core.read.dataaccess.HollowObjectTypeDataAccess;
import com.netflix.hollow.core.schema.HollowObjectSchema;

public abstract class HollowObject
implements HollowRecord {
    protected final int ordinal;
    protected final HollowObjectDelegate delegate;

    public HollowObject(HollowObjectDelegate delegate, int ordinal) {
        this.ordinal = ordinal;
        this.delegate = delegate;
    }

    @Override
    public final int getOrdinal() {
        return this.ordinal;
    }

    public final boolean isNull(String fieldName) {
        return this.delegate.isNull(this.ordinal, fieldName);
    }

    public final boolean getBoolean(String fieldName) {
        return this.delegate.getBoolean(this.ordinal, fieldName);
    }

    public final int getOrdinal(String fieldName) {
        return this.delegate.getOrdinal(this.ordinal, fieldName);
    }

    public final int getInt(String fieldName) {
        return this.delegate.getInt(this.ordinal, fieldName);
    }

    public final long getLong(String fieldName) {
        return this.delegate.getLong(this.ordinal, fieldName);
    }

    public final float getFloat(String fieldName) {
        return this.delegate.getFloat(this.ordinal, fieldName);
    }

    public final double getDouble(String fieldName) {
        return this.delegate.getDouble(this.ordinal, fieldName);
    }

    public final String getString(String fieldName) {
        return this.delegate.getString(this.ordinal, fieldName);
    }

    public final boolean isStringFieldEqual(String fieldName, String testValue) {
        return this.delegate.isStringFieldEqual(this.ordinal, fieldName, testValue);
    }

    public final byte[] getBytes(String fieldName) {
        return this.delegate.getBytes(this.ordinal, fieldName);
    }

    @Override
    public HollowObjectSchema getSchema() {
        return this.delegate.getSchema();
    }

    @Override
    public HollowObjectTypeDataAccess getTypeDataAccess() {
        return this.delegate.getTypeDataAccess();
    }

    public int hashCode() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        HollowObject hollowObj;
        if (obj instanceof HollowObject && this.ordinal == (hollowObj = (HollowObject)obj).getOrdinal()) {
            String otherType = hollowObj.getSchema().getName();
            String myType = this.getSchema().getName();
            return myType.equals(otherType);
        }
        return false;
    }

    public String toString() {
        return "Hollow Object: " + this.getSchema().getName() + " (" + this.ordinal + ")";
    }

    @Override
    public HollowRecordDelegate getDelegate() {
        return this.delegate;
    }
}

