/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.metrics;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import java.util.Collection;
import java.util.HashMap;

public abstract class HollowMetrics {
    private HashMap<String, Long> typeHeapFootprint = new HashMap();
    private HashMap<String, Integer> typePopulatedOrdinals = new HashMap();
    private long currentVersion;
    private long totalHeapFootprint = 0L;
    private int totalPopulatedOrdinals = 0;

    protected void update(long version) {
        this.setCurrentVersion(version);
    }

    protected void update(HollowReadStateEngine hollowReadStateEngine, long version) {
        this.setCurrentVersion(version);
        this.calculateTypeMetrics(hollowReadStateEngine);
    }

    void calculateTypeMetrics(HollowReadStateEngine hollowReadStateEngine) {
        Collection<HollowTypeReadState> typeStates = hollowReadStateEngine.getTypeStates();
        if (typeStates == null) {
            return;
        }
        this.totalHeapFootprint = 0L;
        this.totalPopulatedOrdinals = 0;
        for (HollowTypeReadState typeState : typeStates) {
            long heapCost = typeState.getApproximateHeapFootprintInBytes();
            this.totalHeapFootprint += heapCost;
            int populatedOrdinals = typeState.getPopulatedOrdinals().cardinality();
            this.totalPopulatedOrdinals += populatedOrdinals;
            String type = typeState.getSchema().getName();
            this.typeHeapFootprint.put(type, heapCost);
            this.typePopulatedOrdinals.put(type, populatedOrdinals);
        }
    }

    public HashMap<String, Long> getTypeHeapFootprint() {
        return this.typeHeapFootprint;
    }

    public HashMap<String, Integer> getTypePopulatedOrdinals() {
        return this.typePopulatedOrdinals;
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public long getTotalHeapFootprint() {
        return this.totalHeapFootprint;
    }

    public long getTotalPopulatedOrdinals() {
        return this.totalPopulatedOrdinals;
    }

    public void setCurrentVersion(long version) {
        this.currentVersion = version;
    }
}

