/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.consumer.index;

import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.consumer.index.MatchFieldPathArgumentExtractor;
import com.netflix.hollow.api.consumer.index.SelectFieldPathResultExtractor;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.objects.HollowRecord;
import com.netflix.hollow.core.index.FieldPaths;
import com.netflix.hollow.core.index.HollowHashIndex;
import com.netflix.hollow.core.index.HollowHashIndexResult;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HashIndexSelect<T extends HollowRecord, S extends HollowRecord, Q>
implements HollowConsumer.RefreshListener,
HollowConsumer.RefreshRegistrationListener,
Function<Q, Stream<S>> {
    final HollowConsumer consumer;
    HollowAPI api;
    final SelectFieldPathResultExtractor<S> selectField;
    final List<MatchFieldPathArgumentExtractor<Q>> matchFields;
    final String rootTypeName;
    final String selectFieldPath;
    final String[] matchFieldPaths;
    HollowHashIndex hhi;

    HashIndexSelect(HollowConsumer consumer, Class<T> rootType, SelectFieldPathResultExtractor<S> selectField, List<MatchFieldPathArgumentExtractor<Q>> matchFields) {
        this.consumer = consumer;
        this.api = consumer.getAPI();
        this.selectField = selectField;
        this.matchFields = matchFields;
        this.selectFieldPath = selectField.fieldPath.getSegments().stream().map(FieldPaths.FieldSegment::getName).collect(Collectors.joining("."));
        this.matchFieldPaths = (String[])matchFields.stream().map(mf -> mf.fieldPath.getSegments().stream().map(FieldPaths.FieldSegment::getName).collect(Collectors.joining("."))).toArray(String[]::new);
        this.rootTypeName = HollowObjectTypeMapper.getDefaultTypeName(rootType);
        this.hhi = new HollowHashIndex(consumer.getStateEngine(), this.rootTypeName, this.selectFieldPath, this.matchFieldPaths);
    }

    HashIndexSelect(HollowConsumer consumer, Class<T> rootType, Class<S> selectType, String selectField, Class<Q> matchFieldsType) {
        this(consumer, rootType, SelectFieldPathResultExtractor.from(consumer.getAPI().getClass(), consumer.getStateEngine(), rootType, selectField, selectType), MatchFieldPathArgumentExtractor.fromHolderClass(consumer.getStateEngine(), rootType, matchFieldsType, FieldPaths::createFieldPathForHashIndex));
    }

    HashIndexSelect(HollowConsumer consumer, Class<T> rootType, Class<S> selectType, String selectField, String fieldPath, Class<Q> matchFieldType) {
        this(consumer, rootType, SelectFieldPathResultExtractor.from(consumer.getAPI().getClass(), consumer.getStateEngine(), rootType, selectField, selectType), Collections.singletonList(MatchFieldPathArgumentExtractor.fromPathAndType(consumer.getStateEngine(), rootType, fieldPath, matchFieldType, FieldPaths::createFieldPathForHashIndex)));
    }

    @Override
    public Stream<S> apply(Q query) {
        return this.findMatches(query);
    }

    public Stream<S> findMatches(Q query) {
        Object[] queryArray = this.matchFields.stream().map(mf -> mf.extract(query)).toArray();
        HollowHashIndexResult matches = this.hhi.findMatches(queryArray);
        if (matches == null) {
            return Stream.empty();
        }
        return matches.stream().mapToObj(i -> (HollowRecord)this.selectField.extract(this.api, i));
    }

    @Override
    public void refreshStarted(long currentVersion, long requestedVersion) {
    }

    @Override
    public void snapshotUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) {
        HollowHashIndex hhi = this.hhi;
        hhi.detachFromDeltaUpdates();
        hhi = new HollowHashIndex(this.consumer.getStateEngine(), this.rootTypeName, this.selectFieldPath, this.matchFieldPaths);
        hhi.listenForDeltaUpdates();
        this.hhi = hhi;
        this.api = api;
    }

    @Override
    public void deltaUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) {
        this.api = api;
    }

    @Override
    public void blobLoaded(HollowConsumer.Blob transition) {
    }

    @Override
    public void refreshSuccessful(long beforeVersion, long afterVersion, long requestedVersion) {
    }

    @Override
    public void refreshFailed(long beforeVersion, long afterVersion, long requestedVersion, Throwable failureCause) {
    }

    @Override
    public void onBeforeAddition(HollowConsumer c) {
        if (c != this.consumer) {
            throw new IllegalStateException("The index's consumer and the listener's consumer are not the same");
        }
        this.hhi.listenForDeltaUpdates();
    }

    @Override
    public void onAfterRemoval(HollowConsumer c) {
        this.hhi.detachFromDeltaUpdates();
    }

    public static class BuilderWithSelect<T extends HollowRecord, S extends HollowRecord> {
        final HollowConsumer consumer;
        final Class<T> rootType;
        final String selectFieldPath;
        final Class<S> selectFieldType;

        BuilderWithSelect(HollowConsumer consumer, Class<T> rootType, String selectFieldPath, Class<S> selectFieldType) {
            this.consumer = consumer;
            this.rootType = rootType;
            this.selectFieldPath = selectFieldPath;
            this.selectFieldType = selectFieldType;
        }

        public <Q> HashIndexSelect<T, S, Q> usingBean(Class<Q> queryType) {
            Objects.requireNonNull(queryType);
            return new HashIndexSelect<T, S, Q>(this.consumer, this.rootType, this.selectFieldType, this.selectFieldPath, queryType);
        }

        public <Q> HashIndexSelect<T, S, Q> usingPath(String queryFieldPath, Class<Q> queryFieldType) {
            Objects.requireNonNull(queryFieldPath);
            if (queryFieldPath.isEmpty()) {
                throw new IllegalArgumentException("selectFieldPath argument is an empty String");
            }
            Objects.requireNonNull(queryFieldType);
            return new HashIndexSelect<T, S, Q>(this.consumer, this.rootType, this.selectFieldType, this.selectFieldPath, queryFieldPath, queryFieldType);
        }
    }
}

