/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.testdata;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;

class HollowSetTypeTestDataAPIClassGenerator {
    private final HollowDataset dataset;
    private final HollowSetSchema schema;
    private final String packageName;
    private final String className;
    private final String elementClassName;

    public HollowSetTypeTestDataAPIClassGenerator(HollowDataset dataset, HollowSetSchema schema, String packageName) {
        this.dataset = dataset;
        this.schema = schema;
        this.packageName = packageName;
        this.className = schema.getName() + "TestData";
        this.elementClassName = schema.getElementType() + "TestData";
    }

    public String generate() {
        HollowObjectSchema elementObjSchema;
        StringBuilder builder = new StringBuilder();
        builder.append("package " + this.packageName + ";\n\n");
        builder.append("import com.netflix.hollow.api.testdata.HollowTestSetRecord;\nimport com.netflix.hollow.core.schema.HollowSetSchema;\n\n");
        builder.append("public class " + this.className + "<T> extends HollowTestSetRecord<T> {\n\n");
        builder.append("    " + this.className + "(T parent) {\n");
        builder.append("        super(parent);\n");
        builder.append("    }\n\n");
        String elementReturnType = this.elementClassName + "<" + this.className + "<T>>";
        builder.append("    public " + elementReturnType + " " + this.schema.getElementType() + "() {\n");
        builder.append("        " + elementReturnType + " __e = new " + elementReturnType + "(this);\n");
        builder.append("        super.addElement(__e);\n");
        builder.append("        return __e;\n");
        builder.append("    }\n\n");
        HollowSchema elementSchema = this.dataset.getSchema(this.schema.getElementType());
        if (elementSchema.getSchemaType() == HollowSchema.SchemaType.OBJECT && (elementObjSchema = (HollowObjectSchema)elementSchema).numFields() == 1 && elementObjSchema.getFieldType(0) != HollowObjectSchema.FieldType.REFERENCE) {
            switch (elementObjSchema.getFieldType(0)) {
                case INT: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(Integer value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
                case LONG: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(Long value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
                case FLOAT: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(Float value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
                case DOUBLE: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(Double value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
                case BOOLEAN: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(Boolean value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
                case BYTES: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(byte[] value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
                case STRING: {
                    builder.append("    public " + this.className + "<T> " + this.schema.getElementType() + "(String value) {\n");
                    builder.append("        " + this.schema.getElementType() + "()." + elementObjSchema.getFieldName(0) + "(value);\n");
                    builder.append("        return this;\n");
                    builder.append("    }\n\n");
                    break;
                }
            }
        }
        builder.append("    private static final HollowSetSchema SCHEMA = new HollowSetSchema(\"").append(this.schema.getName()).append("\", \"").append(this.schema.getElementType()).append("\"");
        if (this.schema.getHashKey() != null) {
            for (String fieldPath : this.schema.getHashKey().getFieldPaths()) {
                builder.append(", \"" + fieldPath + "\"");
            }
        }
        builder.append(");\n\n");
        builder.append("    @Override public HollowSetSchema getSchema() { return SCHEMA; }\n\n");
        builder.append("}");
        return builder.toString();
    }
}

