/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.testdata;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;

class HollowMapTypeTestDataAPIClassGenerator {
    private final HollowDataset dataset;
    private final HollowMapSchema schema;
    private final String packageName;
    private final String className;
    private final String keyClassName;
    private final String valueClassName;

    public HollowMapTypeTestDataAPIClassGenerator(HollowDataset dataset, HollowMapSchema schema, String packageName) {
        this.dataset = dataset;
        this.schema = schema;
        this.packageName = packageName;
        this.className = schema.getName() + "TestData";
        this.keyClassName = schema.getKeyType() + "TestData";
        this.valueClassName = schema.getValueType() + "TestData";
    }

    public String generate() {
        StringBuilder builder = new StringBuilder();
        builder.append("package " + this.packageName + ";\n\n");
        builder.append("import com.netflix.hollow.api.testdata.HollowTestMapRecord;\nimport com.netflix.hollow.core.schema.HollowMapSchema;\n\n");
        builder.append("public class " + this.className + "<T> extends HollowTestMapRecord<T> {\n\n");
        builder.append("    " + this.className + "(T parent) {\n");
        builder.append("        super(parent);\n");
        builder.append("    }\n\n");
        builder.append("    public Entry entry() {\n");
        builder.append("        Entry e = new Entry();\n");
        builder.append("        addEntry(e);\n");
        builder.append("        return e;\n");
        builder.append("    }\n\n");
        if (this.canErgonomicShortcut(this.schema.getKeyType()) && this.canErgonomicShortcut(this.schema.getValueType())) {
            String string = this.getErgonomicShortcutType(this.schema.getKeyType());
            String valueType = this.getErgonomicShortcutType(this.schema.getValueType());
            builder.append("    public " + this.className + "<T> entry(" + string + " key, " + valueType + " value) {\n");
            builder.append("        entry().key(key).value(value);\n");
            builder.append("        return this;\n");
            builder.append("    }\n\n");
        } else if (this.canErgonomicShortcut(this.schema.getKeyType())) {
            // empty if block
        }
        builder.append("    private static final HollowMapSchema SCHEMA = new HollowMapSchema(\"" + this.schema.getName() + "\", \"" + this.schema.getKeyType() + "\", \"" + this.schema.getValueType() + "\"");
        if (this.schema.getHashKey() != null) {
            for (String fieldPath : this.schema.getHashKey().getFieldPaths()) {
                builder.append(", \"" + fieldPath + "\"");
            }
        }
        builder.append(");\n\n");
        builder.append("    @Override public HollowMapSchema getSchema() { return SCHEMA; }\n\n");
        builder.append("    public class Entry extends HollowTestMapRecord.Entry<" + this.className + "<T>> {\n\n");
        builder.append("        public Entry() {\n");
        builder.append("            super(" + this.className + ".this);\n");
        builder.append("        }\n\n");
        builder.append("        public " + this.keyClassName + "<Entry> key() {\n");
        builder.append("            " + this.keyClassName + "<Entry> __k = new " + this.keyClassName + "<>(this);\n");
        builder.append("            setKey(__k);\n");
        builder.append("            return __k;\n");
        builder.append("        }\n\n");
        builder.append("        public " + this.valueClassName + "<Entry> value() {\n");
        builder.append("            " + this.valueClassName + "<Entry> __v = new " + this.valueClassName + "<>(this);\n");
        builder.append("            setValue(__v);\n");
        builder.append("            return __v;\n");
        builder.append("        }\n\n");
        if (this.canErgonomicShortcut(this.schema.getKeyType())) {
            String string = this.getErgonomicShortcutType(this.schema.getKeyType());
            String keyFieldName = this.getErgonomicFieldName(this.schema.getKeyType());
            builder.append("        public Entry key(" + string + " key) {\n");
            builder.append("            key()." + keyFieldName + "(key);\n");
            builder.append("            return this;\n");
            builder.append("        }\n\n");
        }
        if (this.canErgonomicShortcut(this.schema.getValueType())) {
            String string = this.getErgonomicShortcutType(this.schema.getValueType());
            String valueFieldName = this.getErgonomicFieldName(this.schema.getValueType());
            builder.append("        public Entry value(" + string + " value) {\n");
            builder.append("            value()." + valueFieldName + "(value);\n");
            builder.append("            return this;\n");
            builder.append("        }\n\n");
        }
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }

    public String className(String type) {
        return type + "TestData";
    }

    private boolean canErgonomicShortcut(String schemaName) {
        return this.canErgonomicShortcut(this.dataset.getSchema(schemaName));
    }

    private boolean canErgonomicShortcut(HollowSchema schema) {
        if (schema.getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            return false;
        }
        HollowObjectSchema objSchema = (HollowObjectSchema)schema;
        if (objSchema.numFields() != 1) {
            return false;
        }
        return objSchema.getFieldType(0) != HollowObjectSchema.FieldType.REFERENCE;
    }

    private String getErgonomicShortcutType(String schemaName) {
        HollowObjectSchema schema = (HollowObjectSchema)this.dataset.getSchema(schemaName);
        switch (schema.getFieldType(0)) {
            case INT: {
                return "Integer";
            }
            case LONG: {
                return "Long";
            }
            case FLOAT: {
                return "Float";
            }
            case DOUBLE: {
                return "Double";
            }
            case BOOLEAN: {
                return "Boolean";
            }
            case BYTES: {
                return "byte[]";
            }
            case STRING: {
                return "String";
            }
        }
        throw new IllegalArgumentException();
    }

    private String getErgonomicFieldName(String schemaName) {
        HollowObjectSchema schema = (HollowObjectSchema)this.dataset.getSchema(schemaName);
        return schema.getFieldName(0);
    }
}

