/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.objects;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.objects.HollowCollectionsGenerator;
import com.netflix.hollow.api.objects.HollowMap;
import com.netflix.hollow.api.objects.delegate.HollowMapDelegate;
import com.netflix.hollow.api.objects.generic.GenericHollowRecordHelper;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.Arrays;
import java.util.Set;

public class HollowMapJavaGenerator
extends HollowCollectionsGenerator {
    private final HollowMapSchema schema;
    private final String keyClassName;
    private final String valueClassName;
    private final boolean parameterizeKey;
    private final boolean parameterizeValue;

    public HollowMapJavaGenerator(String packageName, String apiClassname, HollowMapSchema schema, HollowDataset dataset, Set<String> parameterizedTypes, boolean parameterizeClassNames, CodeGeneratorConfig config) {
        super(packageName, apiClassname, schema, dataset, config);
        this.schema = schema;
        this.keyClassName = this.hollowImplClassname(schema.getKeyType());
        this.valueClassName = this.hollowImplClassname(schema.getValueType());
        this.parameterizeKey = parameterizeClassNames || parameterizedTypes.contains(schema.getKeyType());
        this.parameterizeValue = parameterizeClassNames || parameterizedTypes.contains(schema.getValueType());
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname, Arrays.asList(this.schema));
        builder.append("import " + HollowMap.class.getName() + ";\n");
        builder.append("import " + HollowMapSchema.class.getName() + ";\n");
        builder.append("import " + HollowMapDelegate.class.getName() + ";\n");
        builder.append("import " + GenericHollowRecordHelper.class.getName() + ";\n\n");
        this.appendGeneratedAnnotation(builder);
        builder.append("\n@SuppressWarnings(\"all\")\n");
        String keyGeneric = this.parameterizeKey ? "K" : this.keyClassName;
        String valueGeneric = this.parameterizeValue ? "V" : this.valueClassName;
        String classGeneric = "";
        if (this.parameterizeKey && this.parameterizeValue) {
            classGeneric = "<K, V>";
        } else if (this.parameterizeKey) {
            classGeneric = "<K>";
        } else if (this.parameterizeValue) {
            classGeneric = "<V>";
        }
        builder.append("public class " + this.className + classGeneric + " extends HollowMap<" + keyGeneric + ", " + valueGeneric + "> {\n\n");
        this.appendConstructor(builder);
        this.appendInstantiateMethods(builder);
        this.appendGetByHashKeyMethod(builder);
        this.appendEqualityMethods(builder);
        this.appendAPIAccessor(builder);
        this.appendTypeAPIAccessor(builder);
        builder.append("}");
        return builder.toString();
    }

    private void appendConstructor(StringBuilder classBuilder) {
        classBuilder.append("    public " + this.className + "(HollowMapDelegate delegate, int ordinal) {\n");
        classBuilder.append("        super(delegate, ordinal);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendInstantiateMethods(StringBuilder classBuilder) {
        String keyReturnType = this.parameterizeKey ? "K" : this.keyClassName;
        String valueReturnType = this.parameterizeValue ? "V" : this.valueClassName;
        classBuilder.append("    @Override\n");
        classBuilder.append("    public " + keyReturnType + " instantiateKey(int ordinal) {\n");
        classBuilder.append("        return (" + keyReturnType + ") api().get").append(this.keyClassName).append("(ordinal);\n");
        classBuilder.append("    }\n\n");
        classBuilder.append("    @Override\n");
        classBuilder.append("    public " + valueReturnType + " instantiateValue(int ordinal) {\n");
        classBuilder.append("        return (" + valueReturnType + ") api().get").append(this.valueClassName).append("(ordinal);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendGetByHashKeyMethod(StringBuilder classBuilder) {
        if (this.schema.getHashKey() != null) {
            int i;
            String valueReturnType = this.parameterizeValue ? "V" : this.valueClassName;
            classBuilder.append("    public " + valueReturnType + " get(");
            classBuilder.append(this.getKeyFieldType(this.schema.getHashKey().getFieldPath(0))).append(" k0");
            for (i = 1; i < this.schema.getHashKey().numFields(); ++i) {
                classBuilder.append(", ").append(this.getKeyFieldType(this.schema.getHashKey().getFieldPath(i))).append(" k").append(i);
            }
            classBuilder.append(") {\n");
            classBuilder.append("        return findValue(k0");
            for (i = 1; i < this.schema.getHashKey().numFields(); ++i) {
                classBuilder.append(", k").append(i);
            }
            classBuilder.append(");\n");
            classBuilder.append("    }\n\n");
        }
    }

    private void appendEqualityMethods(StringBuilder classBuilder) {
        classBuilder.append("    @Override\n");
        classBuilder.append("    public boolean equalsKey(int keyOrdinal, Object testObject) {\n");
        classBuilder.append("        return GenericHollowRecordHelper.equalObject(getSchema().getKeyType(), keyOrdinal, testObject);\n");
        classBuilder.append("    }\n\n");
        classBuilder.append("    @Override\n");
        classBuilder.append("    public boolean equalsValue(int valueOrdinal, Object testObject) {\n");
        classBuilder.append("        return GenericHollowRecordHelper.equalObject(getSchema().getValueType(), valueOrdinal, testObject);\n");
        classBuilder.append("    }\n\n");
    }

    private void appendAPIAccessor(StringBuilder classBuilder) {
        classBuilder.append("    public " + this.apiClassname + " api() {\n");
        classBuilder.append("        return typeApi().getAPI();\n");
        classBuilder.append("    }\n\n");
    }

    private void appendTypeAPIAccessor(StringBuilder classBuilder) {
        String typeAPIClassname = HollowCodeGenerationUtils.typeAPIClassname(this.schema.getName());
        classBuilder.append("    public " + typeAPIClassname + " typeApi() {\n");
        classBuilder.append("        return (").append(typeAPIClassname).append(") delegate.getTypeAPI();\n");
        classBuilder.append("    }\n\n");
    }

    private String getKeyFieldType(String fieldPath) {
        try {
            int idx;
            HollowObjectSchema keySchema = (HollowObjectSchema)this.dataset.getSchema(this.schema.getKeyType());
            String[] fieldPathElements = fieldPath.split("\\.");
            for (idx = 0; idx < fieldPathElements.length - 1; ++idx) {
                keySchema = (HollowObjectSchema)this.dataset.getSchema(keySchema.getReferencedType(fieldPathElements[idx]));
            }
            HollowObjectSchema.FieldType fieldType = keySchema.getFieldType(keySchema.getPosition(fieldPathElements[idx]));
            return HollowCodeGenerationUtils.getJavaBoxedType(fieldType);
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("Field path '" + fieldPath + "' specified incorrectly for type: " + this.schema.getName());
        }
    }
}

