/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.indexes;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.indexes.HollowUniqueKeyIndexGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import java.util.ArrayList;

public class HollowPrimaryKeyIndexGenerator
extends HollowUniqueKeyIndexGenerator {
    protected final PrimaryKey pk;

    public HollowPrimaryKeyIndexGenerator(HollowDataset dataset, String packageName, String apiClassname, HollowObjectSchema schema, CodeGeneratorConfig config) {
        super(packageName, apiClassname, schema, dataset, config);
        this.pk = schema.getPrimaryKey();
        this.isGenSimpleConstructor = true;
        this.isParameterizedConstructorPublic = false;
        this.isAutoListenToDataRefresh = false;
        this.isImplementsUniqueKeyIndex = false;
    }

    @Override
    protected String getClassName(HollowObjectSchema schema) {
        return schema.getName() + "PrimaryKeyIndex";
    }

    @Override
    protected void genFindMatchAPI(StringBuilder builder) {
        ArrayList<String> params = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (int i = 0; i < this.pk.numFields(); ++i) {
            String fp = this.pk.getFieldPath(i);
            String fn = HollowCodeGenerationUtils.normalizeFieldPathToParamName(fp);
            fieldNames.add(fn);
            HollowObjectSchema.FieldType ft = this.pk.getFieldType(this.dataset, i);
            if (HollowObjectSchema.FieldType.REFERENCE.equals((Object)ft)) {
                HollowObjectSchema refSchema = this.pk.getFieldSchema(this.dataset, i);
                params.add(refSchema.getName() + " " + fn);
                continue;
            }
            params.add(HollowCodeGenerationUtils.getJavaScalarType(ft) + " " + fn);
        }
        StringBuilder paramsAsStr = new StringBuilder();
        StringBuilder fieldNamesAsStr = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            if (i > 0) {
                paramsAsStr.append(", ");
                fieldNamesAsStr.append(", ");
            }
            paramsAsStr.append((String)params.get(i));
            fieldNamesAsStr.append((String)fieldNames.get(i));
        }
        builder.append("    public " + this.hollowImplClassname(this.schema.getName()) + " findMatch(" + paramsAsStr + ") {\n");
        builder.append("        int ordinal = idx.getMatchingOrdinal(" + fieldNamesAsStr + ");\n");
        builder.append("        if(ordinal == -1)\n");
        builder.append("            return null;\n");
        builder.append("        return api.get" + this.hollowImplClassname(this.schema.getName()) + "(ordinal);\n");
        builder.append("    }\n\n");
    }

    @Override
    protected void genDeprecatedJavaDoc(StringBuilder builder) {
        String typeName = this.hollowImplClassname(this.type);
        builder.append(" * @deprecated see {@link com.netflix.hollow.api.consumer.index.UniqueKeyIndex} which can be created as follows:\n");
        builder.append(" * <pre>{@code\n");
        if (this.pk.numFields() > 1) {
            builder.append(String.format(" *     UniqueKeyIndex<%s, %1$s.Key> uki = %1$s.uniqueIndex(consumer);\n", typeName));
            builder.append(String.format(" *     %s.Key k = new %1$s.Key(...);\n", typeName));
            builder.append(String.format(" *     %s m = uki.findMatch(k);\n", typeName));
        } else {
            String keyName;
            HollowObjectSchema.FieldType ft = this.pk.getFieldType(this.dataset, 0);
            if (HollowObjectSchema.FieldType.REFERENCE.equals((Object)ft)) {
                HollowObjectSchema refSchema = this.pk.getFieldSchema(this.dataset, 0);
                keyName = this.hollowImplClassname(refSchema.getName());
            } else {
                keyName = HollowCodeGenerationUtils.getJavaScalarType(ft);
            }
            builder.append(String.format(" *     UniqueKeyIndex<%1$s, %2$s> uki = %1$s.uniqueIndex(consumer);\n", typeName, keyName));
            builder.append(String.format(" *     %s k = ...;\n", keyName));
            builder.append(String.format(" *     %s m = uki.findMatch(k);\n", typeName));
        }
        builder.append(" * }</pre>\n");
        builder.append(String.format(" * @see %s#uniqueIndex\n", typeName));
    }
}

