/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen.api;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowCodeGenerationUtils;
import com.netflix.hollow.api.codegen.api.HollowTypeAPIGenerator;
import com.netflix.hollow.api.custom.HollowMapTypeAPI;
import com.netflix.hollow.api.objects.delegate.HollowMapLookupDelegate;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.schema.HollowMapSchema;

public class TypeAPIMapJavaGenerator
extends HollowTypeAPIGenerator {
    private final HollowMapSchema schema;

    public TypeAPIMapJavaGenerator(String apiClassname, String packageName, HollowMapSchema schema, HollowDataset dataset, CodeGeneratorConfig config) {
        super(apiClassname, packageName, schema, dataset, config);
        this.schema = schema;
    }

    @Override
    public String generate() {
        StringBuilder builder = new StringBuilder();
        this.appendPackageAndCommonImports(builder, this.apiClassname);
        builder.append("import " + HollowMapTypeAPI.class.getName() + ";\n\n");
        builder.append("import " + HollowMapTypeDataAccess.class.getName() + ";\n");
        builder.append("import " + HollowMapLookupDelegate.class.getName() + ";\n");
        this.appendGeneratedAnnotation(builder);
        builder.append("\n@SuppressWarnings(\"all\")\n");
        builder.append("public class ").append(this.className).append(" extends HollowMapTypeAPI {\n\n");
        builder.append("    private final ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append(" delegateLookupImpl;\n\n");
        builder.append("    public ").append(this.className).append("(").append(this.apiClassname).append(" api, HollowMapTypeDataAccess dataAccess) {\n");
        builder.append("        super(api, dataAccess);\n");
        builder.append("        this.delegateLookupImpl = new ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append("(this);\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getKeyType())).append(" getKeyAPI() {\n");
        builder.append("        return getAPI().get").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getKeyType())).append("();\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getValueType())).append(" getValueAPI() {\n");
        builder.append("        return getAPI().get").append(HollowCodeGenerationUtils.typeAPIClassname(this.schema.getValueType())).append("();\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(HollowCodeGenerationUtils.delegateLookupClassname(this.schema)).append(" getDelegateLookupImpl() {\n");
        builder.append("        return delegateLookupImpl;\n");
        builder.append("    }\n\n");
        builder.append("    public ").append(this.apiClassname).append(" getAPI() {\n");
        builder.append("        return (").append(this.apiClassname).append(")api;\n");
        builder.append("    }\n\n");
        builder.append("}");
        return builder.toString();
    }
}

