/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.codegen;

import com.netflix.hollow.api.codegen.CodeGeneratorConfig;
import com.netflix.hollow.api.codegen.HollowAPIGenerator;
import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractHollowAPIGeneratorBuilder<B extends AbstractHollowAPIGeneratorBuilder<?, ?>, G extends HollowAPIGenerator> {
    protected String apiClassname;
    protected String packageName;
    protected HollowDataset dataset;
    protected Set<String> parameterizedTypes = Collections.emptySet();
    protected boolean parameterizeAllClassNames = false;
    protected boolean useErgonomicShortcuts = false;
    protected Path destinationPath;
    protected CodeGeneratorConfig config = new CodeGeneratorConfig();

    protected abstract G instantiateGenerator();

    protected abstract B getBuilder();

    public B withAPIClassname(String apiClassname) {
        this.apiClassname = apiClassname;
        return this.getBuilder();
    }

    public B withPackageName(String packageName) {
        this.packageName = packageName;
        return this.getBuilder();
    }

    public B withDataModel(HollowDataset dataset) {
        this.dataset = dataset;
        return this.getBuilder();
    }

    public B withDataModel(Class<?> ... classes) {
        HollowWriteStateEngine writeEngine = new HollowWriteStateEngine();
        HollowObjectMapper mapper = new HollowObjectMapper(writeEngine);
        for (Class<?> clazz : classes) {
            mapper.initializeTypeState(clazz);
        }
        return this.withDataModel(writeEngine);
    }

    public B withParameterizedTypes(Set<String> parameterizedTypes) {
        this.parameterizedTypes = parameterizedTypes;
        return this.getBuilder();
    }

    public B withParameterizeAllClassNames(boolean parameterizeAllClassNames) {
        this.parameterizeAllClassNames = parameterizeAllClassNames;
        return this.getBuilder();
    }

    public B withClassPostfix(String classPostfix) {
        this.config.setClassPostfix(classPostfix);
        return this.getBuilder();
    }

    public B withGetterPrefix(String getterPrefix) {
        this.config.setGetterPrefix(getterPrefix);
        return this.getBuilder();
    }

    public B withAggressiveSubstitutions(boolean useAggressiveSubstitutions) {
        this.config.setUseAggressiveSubstitutions(useAggressiveSubstitutions);
        return this.getBuilder();
    }

    public B withErgonomicShortcuts() {
        this.useErgonomicShortcuts = true;
        return this.getBuilder();
    }

    public B withPackageGrouping() {
        this.config.setUsePackageGrouping(true);
        return this.getBuilder();
    }

    public B withBooleanFieldErgonomics(boolean useBooleanFieldErgonomics) {
        this.config.setUseBooleanFieldErgonomics(useBooleanFieldErgonomics);
        return this.getBuilder();
    }

    public B reservePrimaryKeyIndexForTypeWithPrimaryKey(boolean reservePrimaryKeyIndexForTypeWithPrimaryKey) {
        this.config.setReservePrimaryKeyIndexForTypeWithPrimaryKey(reservePrimaryKeyIndexForTypeWithPrimaryKey);
        return this.getBuilder();
    }

    public B withRestrictApiToFieldType() {
        this.config.setRestrictApiToFieldType(true);
        return this.getBuilder();
    }

    public B withHollowPrimitiveTypes(boolean useHollowPrimitiveTypes) {
        this.config.setUseHollowPrimitiveTypes(useHollowPrimitiveTypes);
        return this.getBuilder();
    }

    public B withVerboseToString(boolean useVerboseToString) {
        this.config.setUseVerboseToString(useVerboseToString);
        return this.getBuilder();
    }

    public B withDestination(String destinationPath) {
        return this.withDestination(Paths.get(destinationPath, new String[0]));
    }

    public B withDestination(Path destinationPath) {
        this.destinationPath = destinationPath;
        return this.getBuilder();
    }

    public B withMetaInfo(String metaInfoPath) {
        return this.withMetaInfo(Paths.get(metaInfoPath, new String[0]));
    }

    public B withMetaInfo(Path metaInfoPath) {
        this.config.setMetaInfoPath(metaInfoPath);
        return this.getBuilder();
    }

    public B withGeneratedAnnotation() {
        this.config.setUseGeneratedAnnotation(true);
        return this.getBuilder();
    }

    public G build() {
        if (this.apiClassname == null) {
            throw new IllegalStateException("Please specify an API classname (.withAPIClassname()) before calling .build()");
        }
        if (this.packageName == null) {
            throw new IllegalStateException("Please specify a package name (.withPackageName()) before calling .build()");
        }
        if (this.dataset == null) {
            throw new IllegalStateException("Please specify a data model (.withDataModel()) before calling .build()");
        }
        if (this.config.isRestrictApiToFieldType() && !this.useErgonomicShortcuts) {
            throw new IllegalStateException(" restrictApiToFieldType requires withErgonomicShortcuts");
        }
        G generator = this.instantiateGenerator();
        ((HollowAPIGenerator)generator).setCodeGeneratorConfig(this.config);
        return generator;
    }
}

