/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.HollowBlob;
import com.netflix.hollow.api.client.HollowBlobRetriever;
import com.netflix.hollow.api.client.HollowClientMemoryConfig;
import com.netflix.hollow.api.client.HollowUpdateListener;
import com.netflix.hollow.api.consumer.HollowConsumer;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

class HollowClientConsumerBridge {
    HollowClientConsumerBridge() {
    }

    static HollowConsumer.BlobRetriever consumerBlobRetrieverFor(final HollowBlobRetriever blobRetriever) {
        return new HollowConsumer.BlobRetriever(){

            @Override
            public HollowConsumer.HeaderBlob retrieveHeaderBlob(long currentVersion) {
                throw new UnsupportedOperationException();
            }

            @Override
            public HollowConsumer.Blob retrieveSnapshotBlob(long desiredVersion) {
                final HollowBlob blob = blobRetriever.retrieveSnapshotBlob(desiredVersion);
                if (blob == null) {
                    return null;
                }
                return new HollowConsumer.Blob(blob.getFromVersion(), blob.getToVersion()){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return blob.getInputStream();
                    }

                    @Override
                    public File getFile() throws IOException {
                        return blob.getFile();
                    }
                };
            }

            @Override
            public HollowConsumer.Blob retrieveDeltaBlob(long currentVersion) {
                final HollowBlob blob = blobRetriever.retrieveDeltaBlob(currentVersion);
                if (blob == null) {
                    return null;
                }
                return new HollowConsumer.Blob(blob.getFromVersion(), blob.getToVersion()){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return blob.getInputStream();
                    }

                    @Override
                    public File getFile() throws IOException {
                        return blob.getFile();
                    }
                };
            }

            @Override
            public HollowConsumer.Blob retrieveReverseDeltaBlob(long currentVersion) {
                final HollowBlob blob = blobRetriever.retrieveReverseDeltaBlob(currentVersion);
                if (blob == null) {
                    return null;
                }
                return new HollowConsumer.Blob(blob.getFromVersion(), blob.getToVersion()){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return blob.getInputStream();
                    }

                    @Override
                    public File getFile() throws IOException {
                        return blob.getFile();
                    }
                };
            }
        };
    }

    static HollowConsumer.RefreshListener consumerRefreshListenerFor(final HollowUpdateListener listener) {
        return new HollowConsumer.AbstractRefreshListener(){

            @Override
            public void refreshStarted(long currentVersion, long requestedVersion) {
                listener.refreshStarted(currentVersion, requestedVersion);
            }

            @Override
            public void snapshotUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
                listener.dataInitialized(api, stateEngine, version);
            }

            @Override
            public void blobLoaded(final HollowConsumer.Blob transition) {
                listener.transitionApplied(new HollowBlob(transition.getFromVersion(), transition.getToVersion()){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return transition.getInputStream();
                    }

                    @Override
                    public File getFile() throws IOException {
                        return transition.getFile();
                    }
                });
            }

            @Override
            public void deltaUpdateOccurred(HollowAPI api, HollowReadStateEngine stateEngine, long version) throws Exception {
                listener.dataUpdated(api, stateEngine, version);
            }

            @Override
            public void refreshSuccessful(long beforeVersion, long afterVersion, long requestedVersion) {
                listener.refreshCompleted(beforeVersion, afterVersion, requestedVersion);
            }

            @Override
            public void refreshFailed(long beforeVersion, long afterVersion, long requestedVersion, Throwable failureCause) {
                listener.refreshFailed(beforeVersion, afterVersion, requestedVersion, failureCause);
            }
        };
    }

    static HollowClientDoubleSnapshotConfig doubleSnapshotConfigFor(HollowClientMemoryConfig memoryConfig) {
        return new HollowClientDoubleSnapshotConfig(memoryConfig);
    }

    static class HollowClientDoubleSnapshotConfig
    implements HollowConsumer.DoubleSnapshotConfig {
        private final HollowClientMemoryConfig clientMemCfg;
        private int maxDeltasBeforeDoubleSnapshot = 32;

        private HollowClientDoubleSnapshotConfig(HollowClientMemoryConfig clientMemCfg) {
            this.clientMemCfg = clientMemCfg;
        }

        @Override
        public boolean allowDoubleSnapshot() {
            return this.clientMemCfg.allowDoubleSnapshot();
        }

        @Override
        public int maxDeltasBeforeDoubleSnapshot() {
            return this.maxDeltasBeforeDoubleSnapshot;
        }

        public void setMaxDeltasBeforeDoubleSnapshot(int maxDeltas) {
            this.maxDeltasBeforeDoubleSnapshot = maxDeltas;
        }
    }
}

