/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.api.client;

import com.netflix.hollow.api.client.HollowAPIFactory;
import com.netflix.hollow.api.client.HollowAnnouncementWatcher;
import com.netflix.hollow.api.client.HollowBlobRetriever;
import com.netflix.hollow.api.client.HollowClientConsumerBridge;
import com.netflix.hollow.api.client.HollowClientMemoryConfig;
import com.netflix.hollow.api.client.HollowClientUpdater;
import com.netflix.hollow.api.client.HollowUpdateListener;
import com.netflix.hollow.api.client.StackTraceRecorder;
import com.netflix.hollow.api.custom.HollowAPI;
import com.netflix.hollow.api.metrics.HollowConsumerMetrics;
import com.netflix.hollow.core.memory.MemoryMode;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.filter.HollowFilterConfig;
import com.netflix.hollow.core.util.DefaultHashCodeFinder;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import java.util.Collections;

@Deprecated
public class HollowClient {
    protected final HollowAnnouncementWatcher announcementWatcher;
    protected final HollowClientUpdater updater;
    private final HollowClientConsumerBridge.HollowClientDoubleSnapshotConfig doubleSnapshotConfig;

    public HollowClient(HollowBlobRetriever blobRetriever) {
        this(blobRetriever, new HollowAnnouncementWatcher.DefaultWatcher(), HollowUpdateListener.DEFAULT_LISTENER, HollowAPIFactory.DEFAULT_FACTORY, new DefaultHashCodeFinder(new String[0]), HollowClientMemoryConfig.DEFAULT_CONFIG);
    }

    public HollowClient(HollowBlobRetriever blobRetriever, HollowAnnouncementWatcher announcementWatcher, HollowUpdateListener updateListener, HollowAPIFactory apiFactory, HollowClientMemoryConfig memoryConfig) {
        this(blobRetriever, announcementWatcher, updateListener, apiFactory, new DefaultHashCodeFinder(new String[0]), memoryConfig);
    }

    public HollowClient(HollowBlobRetriever blobRetriever, HollowAnnouncementWatcher announcementWatcher, HollowUpdateListener updateListener, HollowAPIFactory apiFactory, HollowObjectHashCodeFinder hashCodeFinder, HollowClientMemoryConfig memoryConfig) {
        this.doubleSnapshotConfig = HollowClientConsumerBridge.doubleSnapshotConfigFor(memoryConfig);
        HollowConsumerMetrics hollowConsumerMetrics = new HollowConsumerMetrics();
        this.updater = new HollowClientUpdater(HollowClientConsumerBridge.consumerBlobRetrieverFor(blobRetriever), Collections.singletonList(HollowClientConsumerBridge.consumerRefreshListenerFor(updateListener)), apiFactory, this.doubleSnapshotConfig, hashCodeFinder, MemoryMode.ON_HEAP, memoryConfig, updateListener, hollowConsumerMetrics, null);
        this.announcementWatcher = announcementWatcher;
        announcementWatcher.setClientToNotify(this);
    }

    public void triggerRefresh() {
        try {
            this.updater.updateTo(this.announcementWatcher.getLatestVersionInfo());
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public void triggerAsyncRefresh() {
        this.announcementWatcher.triggerAsyncRefresh();
    }

    public void triggerRefreshTo(long version) {
        this.announcementWatcher.setLatestVersion(version);
        this.triggerRefresh();
    }

    public void forceDoubleSnapshotNextUpdate() {
        this.updater.forceDoubleSnapshotNextUpdate();
    }

    public void setFilter(HollowFilterConfig filter) {
        this.updater.setFilter(filter);
    }

    public void setMaxDeltas(int maxDeltas) {
        this.doubleSnapshotConfig.setMaxDeltasBeforeDoubleSnapshot(maxDeltas);
    }

    public void clearFailedTransitions() {
        this.updater.clearFailedTransitions();
    }

    public StackTraceRecorder getStaleReferenceUsageStackTraceRecorder() {
        return this.updater.getStaleReferenceUsageStackTraceRecorder();
    }

    public HollowReadStateEngine getStateEngine() {
        return this.updater.getStateEngine();
    }

    public HollowAPI getAPI() {
        return this.updater.getAPI();
    }

    public long getCurrentVersionId() {
        return this.updater.getCurrentVersionId();
    }

    public static class Builder {
        private HollowBlobRetriever blobRetriever = null;
        private HollowAnnouncementWatcher announcementWatcher = new HollowAnnouncementWatcher.DefaultWatcher();
        private HollowUpdateListener updateListener = HollowUpdateListener.DEFAULT_LISTENER;
        private HollowAPIFactory apiFactory = HollowAPIFactory.DEFAULT_FACTORY;
        private HollowClientMemoryConfig memoryConfig = HollowClientMemoryConfig.DEFAULT_CONFIG;

        public Builder withBlobRetriever(HollowBlobRetriever blobRetriever) {
            this.blobRetriever = blobRetriever;
            return this;
        }

        public Builder withAnnouncementWatcher(HollowAnnouncementWatcher announcementWatcher) {
            this.announcementWatcher = announcementWatcher;
            return this;
        }

        public Builder withUpdateListener(HollowUpdateListener updateListener) {
            this.updateListener = updateListener;
            return this;
        }

        public Builder withAPIFactory(HollowAPIFactory apiFactory) {
            this.apiFactory = apiFactory;
            return this;
        }

        public <T extends HollowAPI> Builder withGeneratedAPIClass(Class<T> generatedAPIClass) {
            this.apiFactory = new HollowAPIFactory.ForGeneratedAPI<T>(generatedAPIClass);
            return this;
        }

        public Builder withMemoryConfig(HollowClientMemoryConfig memoryConfig) {
            this.memoryConfig = memoryConfig;
            return this;
        }

        public HollowClient build() {
            if (this.blobRetriever == null) {
                throw new IllegalArgumentException("A HollowBlobRetriever must be specified when building a HollowClient");
            }
            return new HollowClient(this.blobRetriever, this.announcementWatcher, this.updateListener, this.apiFactory, this.memoryConfig);
        }
    }
}

